package com.gaea.iesms.bm.iot.model.response;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 用户下终端信息
 *
 * @author admin
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "查询用户下终端信息")
public class InstCeResourceMeterVo implements Serializable {

    /**
     * 终端验证通过后生成的ID 需拿到表计中进行对比
     */
    private String termAccessGatewayId;
    /**
     * 终端id
     */
    private String devTermId;
    /**
     * 表计的接入网关设备标识
     */
    private String meterAccessGatewayId;
    /**
     * 量测表计标识
     */
    private String meterId;
    /**
     * 量测表计编号
     */
    private String devMeterNo;
    /**
     * 量测表计名称
     */
    private String devMeterName;
    /**
     * 量测表计类型
     */
    private String devMeterType;
    /**
     * 量测表计类型值
     */
    private String devMeterTypeValue;
    /**
     * 量测通信地址
     */
    private String devMeterCommAddr;
    /**
     * 投运时间
     */
    private String gotoRunTime;
    /**
     * CT
     */
    private String ctRate;
    /**
     * PT
     */
    private String ptRate;
    /**
     * 自身倍率
     */
    private String selfRate;
    /**
     * 生产厂家
     */
    private String mfrCode;
    /**
     * 表计型号
     */
    private String modelCode;
    /**
     * 生产日期
     */
    private String prodDate;

    /**
     * 表计量测点id
     */
    private String measPointId;
    /**
     * 量测表计计量起度信息
     */
    private String devMeterStartReadingInfo;
    /**
     * 是否已装接
     */
    private boolean assembly;
    /**
     * 是否存在子节点
     */
    private boolean hasChildren;
    /**
     * 父节点
     */
    private List<String> parent;
}
