package com.gaea.iesms.bm.iot.model.response;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 用户下终端信息
 *
 * @author admin
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "查询用户下终端信息")
public class InstCeResourceTermVo implements Serializable {

    /**
     * 采集终端标识
     */
    private String termId;

    /**
     * 用户id
     */
    private String ceCustId;

    /**
     * 采集终端编号
     */
    private String devTermNo;
    /**
     * 采集终端名称
     */
    private String devTermName;
    /**
     * 采集终端地址
     */
    private String devTermCommAddr;
    /**
     * 安装位置
     */
    private String installRemark;
    /**
     * 通讯规约
     */
    private String devTermCommProto;
    /**
     * SIM卡号
     */
    private String simNo;
    /**
     * 终端型号
     */
    private String modelCode;
    /**
     * 生产厂家
     */
    private String mfrCode;
    /**
     * 通讯状态
     */
    private String communicationStatus;
    /**
     * 生产日期
     */
    private String prodDate;
    /**
     * 用户和终端装接表的编号（拆除用）
     */
    private String instPointTermId;
    /**
     * 终端验证通过后生成的ID 需拿到表计中进行对比
     */
    private String termAccessGatewayId;
    /**
     * 表计的接入网关设备标识
     */
    private String meterAccessGatewayId;
    /**
     * 是否已装接
     */
    private boolean assembly;
    /**
     * 是否存在子节点
     */
    private boolean hasChildren;
    /**
     * 父节点
     */
    private List<String> parent;
}
