package com.gaea.iesms.bm.iot.model.response;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 装接管理
 *
 * @author admin
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName(autoResultMap = true)
@ApiModel(description = "装接管理返回数据类")
public class InstCeResourceVo implements Serializable {

    @ApiModelProperty(value = "用户标识")
    private String userId;

    @ApiModelProperty(value = "终端标识")
    private String termId;

    @ApiModelProperty(value = "用能资源编号")
    private String ceResNo;

    @ApiModelProperty(value = "用户名称")
    private String username;

    @ApiModelProperty(value = "用户地址")
    private String userAddr;

    @ApiModelProperty(value = "手机号码")
    private String contactMobile;

    @ApiModelProperty(value = "用能资源状态")
    private String ceResStatus;

    @ApiModelProperty(value = "用能资源简称")
    private String ceResAbbr;
    /**
     * 用户类型 1高压，2，3低压
     */
    private String consElecSort;

    @ApiModelProperty(value = "用能资源说明")
    private String ceResDesc;

    @ApiModelProperty(value = "是否存在子节点")
    private boolean hasChildren;

    @ApiModelProperty(value = "父节点")
    private List<String> parent;
    /**
     * 社区资源（小区）标识
     */
    private String distNeighborhoodId;
    /**
     * 社区资源（楼栋）标识
     */
    private String distBuildingId;
    /**
     * 社区资源（单元）标识
     */
    private String distBuildingUnitId;
    /**
     * 社区资源（楼层）标识
     */
    private String distBuildingFloorId;
    /**
     * 区域
     */
    private String neighborhood;
}
