package com.gaea.iesms.bm.iot.model.response;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.Data;

import java.io.Serializable;

/**
 * 表计管理导入模板
 *
 * @author admin
 */
@Data
@ExcelTarget("量测设备管理导入模板")
public class MeterManagement implements Serializable {
    // @ApiModelProperty(value = "量测设备类型 1 – 电表；2 – 水表；3 – 气表；4 – 热表；5 - 汽表；6-环境传感器；7-光伏逆变器；8-储能PCS；9-智能断路器；99 - 其他；")
    @Excel(name = "量测设备类型（必填）", replace = {"电表_1", "水表_2", "气表_3", "热表_4", "汽表_5", "环境传感器_6", "光伏逆变器_7", "储能PCS_8", "智能断路器_9", "汽车充电桩_10", "水电机组控制箱_11", "其他_99"})
    private String devMeterType;
    @Excel(name = "量测设备编号（必填）")
    private String devMeterNo;
    @Excel(name = "量测设备名称（必填）")
    private String devMeterName;
    @Excel(name = "量测通信地址")
    private String devMeterCommAddr;
    @Excel(name = "生产厂家（必填）", replace = {"杭州佳和电气股份有限公司_GAEA", "浙江维格泰电力科技有限公司_VECTEK", "上海佳岚智能科技有限公司_JALASMART", "深圳提姆物联网科技有限公司_TIMUIOT", "威胜集团有限公司_VIEWSHINE", "杭州金卡智能系统有限公司_FJLEAD", "浙江威星智能仪表股份有限公司_ZHGXKJ", "杭州先锋电子技术股份有限公司_HOSSNOW", "上海艾临科智能科技有限公司_ELECON", "杭州西力智能科技股份有限公司_CNXILI", "浙江八达电子仪表有限公司_ZJBDYB"})
    private String mfrCode;
    @Excel(name = "设备型号（必填）")
    private String modelCode;
    @Excel(name = "自身倍率")
    private String selfRate;
    @Excel(name = "CT倍率")
    private String ctRate;
    @Excel(name = "PT倍率")
    private String ptRate;
    @Excel(name = "生产日期", format = "yyyy-MM-dd")
    private String prodDate;
    @Excel(name = "硬件版本")
    private String hardwareVersion;
    @Excel(name = "软件版本")
    private String softwareVersion;
}
