package com.gaea.iesms.bm.iot.model.response;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.Data;

/**
 * 终端管理导入模板
 *
 * @author admin
 */
@Data
@ExcelTarget("采集通信终端管理导入模板")
public class TermManagement {

    @Excel(name = "采集通信终端编号（必填）")
    private String devTermNo;

    @Excel(name = "采集通信终端名称（必填）")
    private String devTermName;

    @Excel(name = "采集终端通信地址")
    private String devTermCommAddr;

    @Excel(name = "生产厂家（必填）", replace = {"杭州佳和电气股份有限公司_GAEA", "华为技术有限公司_HUAWEI", "上海佳岚智能科技有限公司_JALASMART", "深圳提姆物联网科技有限公司_TIMUIOT", "浙江八达电子仪表有限公司_ZJBDYB"})
    private String mfrCode;

    @Excel(name = "设备型号（必填）")
    private String modelCode;

    @Excel(name = "运营商卡号")
    private String simNo;

    @Excel(name = "生产日期", format = "yyyy-MM-dd HH:mm:ss")
    private String prodDate;

    @Excel(name = "安装位置")
    private String installRemark;
}
