package com.gaea.iesms.bm.iot.service;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.iot.model.request.GmDevTermRequest;
import com.gaea.iesms.bm.iot.model.request.InstCeResourceRequest;
import com.gaea.iesms.bm.iot.model.request.SaveTermCeResourceRequest;
import com.gaea.iesms.bm.iot.model.request.SaveTermMeterRequest;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceMeterVo;
import com.gaea.iesms.bm.iot.model.response.InstCeResourcePageVo;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceTermVo;

import java.util.List;

/**
 * @author admin
 */
public interface InstCeResourceService {

    /**
     * 装接管理--用户列表
     */
    InstCeResourcePageVo selectInstCeResourcePage(InstCeResourceRequest request);

    /**
     * 查询用户下终端列表
     */
    List<InstCeResourceTermVo> selectInstCeResourceTermList(InstCeResourceRequest request);

    /**
     * 查询终端下表计列表
     */
    List<InstCeResourceMeterVo> selectInstCeResourceMeterList(InstCeResourceRequest request);

    /**
     * 新增终端和用户关系
     */
    R addPointTermCeResource(SaveTermCeResourceRequest request);

    /**
     * 新增终端和表计关系
     */
    R addPointTermMeter(SaveTermMeterRequest request);

    /**
     * 修改终端和表计关系
     */
    R updatePointTermMeter(SaveTermMeterRequest request);

    /**
     * 删除终端和用户关系
     */
    R deletePointTermCeResource(SaveTermCeResourceRequest request);

    /**
     * 更换终端
     */
    void replaceGmDevTerm(GmDevTermRequest request);

    /**
     * 删除终端和表计关系
     */
    R deletePointTermMeter(SaveTermMeterRequest request);

    /**
     * 批量装接-(终端在这个用户下已经装接过 更新这个终端装接的信息)
     */
    int updateBatchInstCeResource(SaveTermMeterRequest request);

    /**
     * 批量装接
     */
    int insertBatchInstCeResource(SaveTermMeterRequest request);
}
