package com.gaea.iesms.bm.iot.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.base.core.R;
import com.gaea.base.vo.PageDataVo;
import com.gaea.iesms.bm.iot.mapper.CommunityConduitMapper;
import com.gaea.iesms.bm.iot.model.request.CommunityConduitPageRequest;
import com.gaea.iesms.bm.iot.model.response.*;
import com.gaea.iesms.bm.iot.service.CommunityConduitService;
import com.gaea.iesms.bm.iot.service.GmDevMeterService;
import com.gaea.iesms.bm.iot.service.GmDevTermService;
import com.gaea.iesms.core.feign.dto.SysCodeSortDTO;
import com.gaea.iesms.core.feign.request.SysCodeSortQueryRequest;
import com.gaea.iesms.core.feign.request.archive.PagedDevicesRequest;
import com.gaea.iesms.core.feign.request.archive.UserPageRequest;
import com.gaea.iesms.core.feign.response.archive.CeCustVo;
import com.gaea.iesms.core.feign.response.archive.CeDeviceVo;
import com.gaea.iesms.core.feign.service.RemoteArchiveService;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.google.common.collect.Maps;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class CommunityConduitServiceImpl implements CommunityConduitService {

    @Resource
    private CommunityConduitMapper communityConduitMapper;

    @Resource
    private RemoteSystemService remoteSystemService;

    @Resource
    private RemoteArchiveService remoteArchiveService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource
    private GmDevTermService gmDevTermService;

    @Override
    public CommunityConduitPageVo selectCommunityConduitPage(CommunityConduitPageRequest request) {
        Page<CommunityConduitVo> page = new Page<>(request.getPageNumber(), request.getPageSize());
        String orgNo = StrUtil.isNotBlank(request.getOrgNo()) ? request.getOrgNo() : AuthUtils.getOrgNo();
        QueryWrapper<CommunityConduitVo> queryWrapper = new QueryWrapper<CommunityConduitVo>()
//                .eq("iptcr.ce_res_class", 1)
                .eq("gdt.is_valid", 1)
//                .eq("iptcr.is_valid", 1)
                .eq("gdt2.is_valid", 1)
                .like(StrUtil.isNotBlank(orgNo), "gdt.org_no", orgNo)
//                .eq(StrUtil.isNotBlank(request.getCeCustId()), "iptcr.ce_res_id", request.getCeCustId())
                .like(StrUtil.isNotBlank(request.getDevTermCommAddr()), "gdt.dev_term_comm_addr", request.getDevTermCommAddr())
                .like(StrUtil.isNotBlank(request.getDevTermNo()), "gdt.dev_term_no", request.getDevTermNo())
                .apply(request.getOnlineOffInState() != null && request.getOnlineOffInState() == 1
                        , "CAST(unix_timestamp(CURRENT_TIMESTAMP()) * 1000 AS SIGNED) - CAST(gdt2.gmt_message_up AS SIGNED) <= (60 * 60 * 1000)")
                .apply(request.getOnlineOffInState() != null && request.getOnlineOffInState() == 2
                        , "CAST(unix_timestamp(CURRENT_TIMESTAMP()) * 1000 AS SIGNED) - CAST(gdt2.gmt_message_up AS SIGNED) > (60 * 60 * 1000)");
        IPage<CommunityConduitVo> iPage = communityConduitMapper.selectCommunityConduitPage(page, queryWrapper);
        //分组，id和名称
        List<CommunityConduitVo> records = iPage.getRecords();
        long time = System.currentTimeMillis() - 60 * 60 * 1000;
        records.forEach(item -> {
            QueryWrapper<CommunityConduitVo> queryWrapper1 = new QueryWrapper<CommunityConduitVo>()
                    .eq("gdm.is_valid", 1)
                    .eq("gdt.is_valid", 1)
                    .eq("ipmcr.is_valid", 1)
                    .eq("gdt.id", item.getDevTermId())
                    .eq("ipmcr.ce_res_id", item.getCeCustId())
                    .apply("CAST(unix_timestamp(CURRENT_TIMESTAMP()) * 1000 AS SIGNED) - CAST(gdm2.gmt_message_up AS SIGNED) <= (60 * 60 * 1000)");
            List<CommunityConduitMeterInfoVo> list = communityConduitMapper.getCommunityConduitMeterInfo(queryWrapper1);
            QueryWrapper<CommunityConduitVo> queryWrapper2 = new QueryWrapper<CommunityConduitVo>()
                    .eq("gdm.is_valid", 1)
                    .eq("gdt.is_valid", 1)
                    .eq("ipmcr.is_valid", 1)
                    .eq("gdt.id", item.getDevTermId())
                    .eq("ipmcr.ce_res_id", item.getCeCustId())
                    .apply("(gdm2.gmt_message_up IS NULL OR CAST(unix_timestamp(CURRENT_TIMESTAMP()) * 1000 AS SIGNED) - CAST(gdm2.gmt_message_up AS SIGNED) > (60 * 60 * 1000))");
            List<CommunityConduitMeterInfoVo> list1 = communityConduitMapper.getCommunityConduitMeterInfo(queryWrapper2);
            item.setMeterOnlineCount(list.size());
            item.setMeterOnlineList(list);
            item.setMeterOfflineCount(list1.size());
            item.setMeterOfflineList(list1);
            if (null != item.getGmtMessageUp() && item.getGmtMessageUp() > time) {
                item.setTermStatus("在线");
            } else {
                item.setTermStatus("离线");
            }
            SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
            sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_TERM_MFR_CODE");
            sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
            R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);
            if (mapR.isSuccess()) {
                item.setMfrName(ObjectUtil.isEmpty(mapR.getData().get(item.getMfrCode()))
                        || StrUtil.isEmpty(mapR.getData().get(item.getMfrCode()).getCodeName()) ? null : mapR.getData().get(item.getMfrCode()).getCodeName());
            }

        });
        CommunityConduitPageVo conduitPageVo = new CommunityConduitPageVo();
        conduitPageVo.setList(records);
        conduitPageVo.setTotal(iPage.getTotal());
        return conduitPageVo;
    }

    @Override
    public Map<String, Object> getCommunityConduitTermInfo(CommunityConduitPageRequest request) {
        String orgNo = StrUtil.isNotBlank(request.getOrgNo()) ? request.getOrgNo() : AuthUtils.getOrgNo();
        QueryWrapper<CommunityConduitVo> queryWrapper = new QueryWrapper<CommunityConduitVo>()
                .like(StrUtil.isNotBlank(orgNo), "gdt.org_no", orgNo)
                .eq("gdt.is_valid", 1)
                .eq("gdt.dev_term_status", 3);
        List<CommunityConduitVo> list = communityConduitMapper.getCommunityConduitTermInfo(queryWrapper);

        //查询有工况表计信息
        List<CommunityConduitVo> meterList = getCommunityMeterInfo(request);
        int total = list.size();
        int sumMeter = meterList.size();
        int termOnLineCount = 0;
        int onLineMeter = 0;
        int termOffLineCount = 0;
        int offLineMeter = 0;
        BigDecimal onLineRate;
        BigDecimal onLineRateMeter;

        for (CommunityConduitVo vo : list) {
            long time = System.currentTimeMillis() - 60 * 60 * 1000;
            if (null != vo) {
                Long gmtMessageUp = vo.getGmtMessageUp();
                if (null == vo.getGmtMessageUp()) {
                    termOffLineCount = termOffLineCount + 1;
                } else {
                    if (gmtMessageUp > time) {
                        termOnLineCount = termOnLineCount + 1;
                    } else {
                        termOffLineCount = termOffLineCount + 1;
                    }
                }
            } else {
                termOffLineCount = termOffLineCount + 1;
            }
        }
        onLineRate = total == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(NumberUtil.mul(NumberUtil.div(termOnLineCount, total), 100)).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();

        //表计
        for (CommunityConduitVo vo : meterList) {
            long time = System.currentTimeMillis() - 60 * 60 * 1000;
            if (null != vo) {
                Long gmtMessageUp = vo.getGmtMessageUp();
                if (null == vo.getGmtMessageUp()) {
                    offLineMeter = offLineMeter + 1;
                } else {
                    if (gmtMessageUp > time) {
                        onLineMeter = onLineMeter + 1;
                    } else {
                        offLineMeter = offLineMeter + 1;
                    }
                }
            } else {
                offLineMeter = offLineMeter + 1;
            }
        }
        onLineRateMeter = total == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(NumberUtil.mul(NumberUtil.div(onLineMeter, sumMeter), 100)).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();

        Map<String, Object> resMap = Maps.newLinkedHashMap();
        resMap.put("total", total);
        resMap.put("termOnLineCount", termOnLineCount);
        resMap.put("termOffLineCount", termOffLineCount);
        resMap.put("termOnLineRate", onLineRate);
        resMap.put("sumMeter", sumMeter);
        resMap.put("onLineMeter", onLineMeter);
        resMap.put("offLineMeter", offLineMeter);
        resMap.put("onLineRateMeter", onLineRateMeter);
        return resMap;
    }

    @Override
    public List<CommunityConduitVo> getCommunityMeterInfo(CommunityConduitPageRequest request) {
        String orgNo = StrUtil.isNotBlank(request.getOrgNo()) ? request.getOrgNo() : AuthUtils.getOrgNo();
        QueryWrapper<CommunityConduitVo> queryWrapper = new QueryWrapper<CommunityConduitVo>()
                .like(StrUtil.isNotBlank(orgNo), "gdm.org_no", orgNo)
                .eq("gdm.is_valid", 1)
                .eq("gdm.dev_meter_status", 3);
        return communityConduitMapper.getCommunityMeterInfo(queryWrapper);
    }

    @Override
    public List<CommunityConduitMeterInfoVo> getCommunityConduitMeterInfo(List<String> devMeterIdList) {
        String orgNo = AuthUtils.getOrgNo();
        QueryWrapper<CommunityConduitVo> queryWrapper = new QueryWrapper<CommunityConduitVo>()
                .like(StrUtil.isNotBlank(orgNo), "gdm.org_no", orgNo)
                .eq("gdm.dev_meter_status", 3)
                .eq("gdm.is_valid", 1)
                .in(CollectionUtil.isNotEmpty(devMeterIdList), "gdm.id", devMeterIdList);
        return communityConduitMapper.getCommunityConduitMeterInfo(queryWrapper);
    }

    @Override
    public TermMeasCommunityConduitVo termMeasCommunityConduit(String ceCustId, String type) {
        String orgNo = AuthUtils.getOrgNo();
        TermMeasCommunityConduitVo termMeasCommunityConduitVo = new TermMeasCommunityConduitVo();
        if (type.equals("1")) {
            QueryWrapper<CommunityConduitVo> queryWrapper = new QueryWrapper<CommunityConduitVo>()
                    .like(StrUtil.isNotBlank(orgNo), "gdt.org_no", orgNo)
                    .eq("gdt.is_valid", 1)
                    .eq("gdt.dev_term_status", 3);
            List<CommunityConduitVo> list = communityConduitMapper.getCommunityConduitTermInfo(queryWrapper);
            termMeasCommunityConduitVo.setIntoCount(list.size());
            int total = list.size();
            int termOnLineCount = 0;
            int termOffLineCount = 0;
            for (CommunityConduitVo vo : list) {
                long time = System.currentTimeMillis() - 60 * 60 * 1000;
                if (null != vo) {
                    Long gmtMessageUp = vo.getGmtMessageUp();
                    if (null == vo.getGmtMessageUp()) {
                        termOffLineCount = termOffLineCount + 1;
                    } else {
                        if (gmtMessageUp > time) {
                            termOnLineCount = termOnLineCount + 1;
                        } else {
                            termOffLineCount = termOffLineCount + 1;
                        }
                    }
                } else {
                    termOffLineCount = termOffLineCount + 1;
                }
            }
            termMeasCommunityConduitVo.setOnlineCount(termOnLineCount);
            termMeasCommunityConduitVo.setOfflineCount(termOffLineCount);
            termMeasCommunityConduitVo.setOnlineRate(total == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(NumberUtil.mul(NumberUtil.div(termOnLineCount, total), 100)).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros());
            return termMeasCommunityConduitVo;
        }

        // 1 – 电表；2 – 水表；3 – 气表；4 – 热表；5 - 汽表；6-环境传感器；7-光伏逆变器；8-储能PMS；9-智能断路器；99 - 其他
        QueryWrapper<CommunityConduitVo> queryWrapper = new QueryWrapper<CommunityConduitVo>()
                .like(StrUtil.isNotBlank(orgNo), "gdm.org_no", orgNo)
                .eq("gdm.is_valid", 1)
                .eq("gdm.dev_meter_status", 3);
        if (!type.equals("2")) {
            queryWrapper.eq("gdm.dev_meter_type", type);
        }
        List<CommunityConduitVo> meterList = communityConduitMapper.getCommunityMeterInfo(queryWrapper);
        int sumMeter = meterList.size();
        int onLineMeter = 0;
        int offLineMeter = 0;
        BigDecimal onLineRateMeter;
        for (CommunityConduitVo vo : meterList) {
            long time = System.currentTimeMillis() - 60 * 60 * 1000;
            if (null != vo) {
                Long gmtMessageUp = vo.getGmtMessageUp();
                if (null == vo.getGmtMessageUp()) {
                    offLineMeter = offLineMeter + 1;
                } else {
                    if (gmtMessageUp > time) {
                        onLineMeter = onLineMeter + 1;
                    } else {
                        offLineMeter = offLineMeter + 1;
                    }
                }
            } else {
                offLineMeter = offLineMeter + 1;
            }
        }
        onLineRateMeter = sumMeter == 0 ? BigDecimal.ZERO : BigDecimal.valueOf(NumberUtil.mul(NumberUtil.div(onLineMeter, sumMeter), 100)).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
        termMeasCommunityConduitVo.setIntoCount(sumMeter);
        termMeasCommunityConduitVo.setOnlineCount(onLineMeter);
        termMeasCommunityConduitVo.setOfflineCount(offLineMeter);
        termMeasCommunityConduitVo.setOnlineRate(onLineRateMeter);
        return termMeasCommunityConduitVo;
    }

    @Override
    public CommunityConduitPageScreenVo selectCommunityConduitPageScreenMeas(CommunityConduitPageRequest request) {
        Page<CommunityConduitMeterInfoVo> page = new Page<>(request.getPageNumber(), request.getPageSize());
        QueryWrapper<CommunityConduitMeterInfoVo> queryWrapper1 = new QueryWrapper<CommunityConduitMeterInfoVo>()
                .eq("gdm.is_valid", 1)
                .eq("gdt.is_valid", 1)
                .eq("ipmcr.is_valid", 1)
                .eq("ipmcr.ce_res_id", request.getCeCustId());

        if (request.getDevMeterType() != null) {
            queryWrapper1.eq("gdm.dev_meter_type",request.getDevMeterType());
        }
        IPage<CommunityConduitMeterInfoVo> iPage = communityConduitMapper.getCommunityConduitMeterInfoPage(page,queryWrapper1);
        List<CommunityConduitMeterInfoVo> list = iPage.getRecords();
        CommunityConduitPageScreenVo communityConduitPageScreenVo=new CommunityConduitPageScreenVo();
        communityConduitPageScreenVo.setTotal(iPage.getTotal());
        List<CommunityConduitPageScreenInfoVo> communityConduitPageScreenInfoVos=new ArrayList<>();


        list.forEach(communityConduitMeterInfoVo -> {
            CommunityConduitPageScreenInfoVo communityConduitPageScreenInfoVo=new CommunityConduitPageScreenInfoVo();
            BeanUtils.copyProperties(communityConduitMeterInfoVo,communityConduitPageScreenInfoVo);
            communityConduitPageScreenInfoVo.setId(communityConduitMeterInfoVo.getMeterId());
            SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
            sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_METER_MFR_CODE");
            sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
            R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);
            if (mapR.isSuccess()) {
                communityConduitPageScreenInfoVo.setMfrName(ObjectUtil.isEmpty(mapR.getData().get(communityConduitMeterInfoVo.getMfrCode()))
                        || StrUtil.isEmpty(mapR.getData().get(communityConduitMeterInfoVo.getMfrCode()).getCodeName()) ? null : mapR.getData().get(communityConduitMeterInfoVo.getMfrCode()).getCodeName());
            }

            communityConduitPageScreenInfoVos.add(communityConduitPageScreenInfoVo);
        });

        if (request.getDevMeterType()!=null){
            PagedDevicesRequest pagedDevicesRequest = new PagedDevicesRequest();
            pagedDevicesRequest.setCeCustId(request.getCeCustId());
            if (request.getDevMeterType().equals("7")){
                pagedDevicesRequest.setCeResSortNo("DEV_PV_INVERTER");
            }
            if (request.getDevMeterType().equals("8")){
                pagedDevicesRequest.setCeResSortNo("DEV_SE_PCS");
            }
            pagedDevicesRequest.setPageNumber(1);
            pagedDevicesRequest.setPageSize(1000);

            PageDataVo<CeDeviceVo> data= remoteArchiveService.listPagedDevices(pagedDevicesRequest).getData();
            if (data!=null){
                communityConduitPageScreenInfoVos.forEach(communityConduitPageScreenInfoVo -> {
                    data.getRecords().forEach(ceDeviceVo -> {
                        if (ceDeviceVo.getCeResourceProps()!=null&&ceDeviceVo.getCeResourceProps().get("correlTableMeter")!=null
                                &&ceDeviceVo.getCeResourceProps().get("correlTableMeter").toString().equals(communityConduitPageScreenInfoVo.getId())){
                            communityConduitPageScreenInfoVo.setCapacity(ceDeviceVo.getCeResourceProps().get("capacity")!=null?ceDeviceVo.getCeResourceProps().get("capacity").toString():null);
                            communityConduitPageScreenInfoVo.setRatedPower(ceDeviceVo.getCeResourceProps().get("ratePower")!=null?ceDeviceVo.getCeResourceProps().get("ratePower").toString():null);
                        }
                    });
                });
            }
        }
        communityConduitPageScreenVo.setList(communityConduitPageScreenInfoVos);
        return communityConduitPageScreenVo;
    }
}
