package com.gaea.iesms.bm.iot.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gaea.iesms.bm.iot.mapper.*;
import com.gaea.iesms.bm.iot.service.DataCenterGmDevMeterService;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import com.gaea.iesms.core.model.entity.iot.GmopsDevMeter;
import com.gaea.iesms.core.model.entity.iot.GmopsDevTerm;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.entity.GmDevTermDo;
import com.iesms.bizprocessors.common.entity.GmopsDevMeterDo;
import com.iesms.bizprocessors.common.entity.GmopsDevTermDo;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.request.GmDevTermGetRequest;
import com.iesms.bizprocessors.common.request.GmopsDevMeterRefreshRequest;
import com.iesms.bizprocessors.common.request.GmopsDevTermRefreshRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import com.iesms.bizprocessors.common.response.GmopsDevTermRefreshResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author admin
 */
@Service
public class DataCenterGmDevMeterServiceImpl implements DataCenterGmDevMeterService {

    @Resource
    private DataCenterGmDevMeterMapper dataCenterGmDevMeterMapper;

    @Resource
    private GmDevTermMapper gmDevTermMapper;

    @Resource
    private GmDevMeterMapper gmDevMeterMapper;

    @Resource
    private GmopsDevTermMapper gmopsDevTermMapper;

    @Resource
    private GmopsDevMeterMapper gmopsDevMeterMapper;


    @Override
    public GmDevMeterGetResponse getGmDevMeter(GmDevMeterGetRequest gmDevMeterGetRequest) {

        GmDevMeterGetResponse gmDevMeterGetResponse = new GmDevMeterGetResponse();
        gmDevMeterGetResponse.setFailureDefault();
        com.iesms.bizprocessors.common.entity.GmDevMeterVo gmDevMeter = null;
        if (gmDevMeterGetRequest != null && gmDevMeterGetRequest.getDevMeterId() != null && gmDevMeterGetRequest.getDevMeterId() > 0L) {
            gmDevMeter = dataCenterGmDevMeterMapper.getGmDevMeterVo(gmDevMeterGetRequest.getDevMeterId());
        } else if (gmDevMeterGetRequest != null && StrUtil.isNotBlank(gmDevMeterGetRequest.getOrgNo())) {
            if (StrUtil.isNotBlank(gmDevMeterGetRequest.getDevMeterNo())) {
                gmDevMeter = dataCenterGmDevMeterMapper.getGmDevMeterVoByOrgNoAndDevMeterNo(gmDevMeterGetRequest.getOrgNo(), gmDevMeterGetRequest.getDevMeterNo());
            } else if (StrUtil.isNotBlank(gmDevMeterGetRequest.getDevMeterCommProto()) && StrUtil.isNotBlank(gmDevMeterGetRequest.getDevMeterCommAddr())) {
                gmDevMeter = dataCenterGmDevMeterMapper.getGmDevMeterVoByOrgNoAndDevMeterCommProtoAndDevMeterCommAddr(gmDevMeterGetRequest.getOrgNo(), gmDevMeterGetRequest.getDevMeterCommProto(), gmDevMeterGetRequest.getDevMeterCommAddr());
            }
        } else if (gmDevMeterGetRequest != null && gmDevMeterGetRequest.getAccessMeasureId() != null && gmDevMeterGetRequest.getAccessMeasureId() > 0L) {
            gmDevMeter = dataCenterGmDevMeterMapper.getGmDevMeterVoByAccessMeasureId(gmDevMeterGetRequest.getAccessMeasureId());
        } else if (gmDevMeterGetRequest != null && gmDevMeterGetRequest.getMeasPointId() != null && gmDevMeterGetRequest.getMeasPointId() > 0L) {
            gmDevMeter = dataCenterGmDevMeterMapper.getGmDevMeterVoByMeasPointId(gmDevMeterGetRequest.getMeasPointId());
        }
        if (gmDevMeter == null) {
            gmDevMeterGetResponse.setFailure("GM_DEV_METER_NOTEXIST", "该量测表计设备不存在");
        } else {
            gmDevMeterGetResponse.setSuccess();
            gmDevMeterGetResponse.setGmDevMeter(gmDevMeter);
        }
        return gmDevMeterGetResponse;
    }

    @Override
    public GmDevTermGetResponse getGmDevTerm(GmDevTermGetRequest gmDevTermGetRequest) {
        GmDevTermGetResponse gmDevTermGetResponse = new GmDevTermGetResponse();
        gmDevTermGetResponse.setFailureDefault();
        GmDevTerm gmDevTerm = null;
        GmDevTermDo gmDevTermDo = new GmDevTermDo();
        if (gmDevTermGetRequest != null && gmDevTermGetRequest.getDevTermId() != null && gmDevTermGetRequest.getDevTermId() > 0L) {
            gmDevTerm = gmDevTermMapper.selectById(gmDevTermGetRequest.getDevTermId());
        } else if (gmDevTermGetRequest != null && StrUtil.isNotBlank(gmDevTermGetRequest.getOrgNo())) {
            if (StrUtil.isNotBlank(gmDevTermGetRequest.getDevTermNo())) {
                QueryWrapper<GmDevTerm> queryWrapper = new QueryWrapper<GmDevTerm>()
                        .eq("org_no", gmDevTermGetRequest.getOrgNo())
                        .eq("dev_term_no", gmDevTermGetRequest.getDevTermNo());
                gmDevTerm = gmDevTermMapper.selectOne(queryWrapper);
            } else if (StrUtil.isNotBlank(gmDevTermGetRequest.getDevTermCommProto()) && StrUtil.isNotBlank(gmDevTermGetRequest.getDevTermCommAddr())) {
                QueryWrapper<GmDevTerm> queryWrapper = new QueryWrapper<GmDevTerm>()
                        .eq("org_no", gmDevTermGetRequest.getOrgNo())
                        .eq("dev_term_comm_proto", gmDevTermGetRequest.getDevTermCommProto())
                        .eq("dev_term_comm_addr", gmDevTermGetRequest.getDevTermCommAddr());
                gmDevTerm = gmDevTermMapper.selectOne(queryWrapper);
            }
        } else if (gmDevTermGetRequest != null && gmDevTermGetRequest.getAccessGatewayId() != null && gmDevTermGetRequest.getAccessGatewayId() > 0L) {
            QueryWrapper<GmDevTerm> queryWrapper = new QueryWrapper<GmDevTerm>()
                    .eq("access_gateway_id", gmDevTermGetRequest.getAccessGatewayId());
            gmDevTerm = gmDevTermMapper.selectOne(queryWrapper);
        }
        if (gmDevTerm == null) {
            gmDevTermGetResponse.setFailure("GM_DEV_TERM_NOTEXIST", "该采集终端设备不存在");
        } else {
            BeanUtils.copyProperties(gmDevTerm, gmDevTermDo);
            gmDevTermGetResponse.setSuccess();
            gmDevTermGetResponse.setGmDevTerm(gmDevTermDo);
        }
        return gmDevTermGetResponse;
    }

    @Override
    public GmopsDevMeterRefreshResponse refreshGmopsDevMeter(GmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest) {
        GmopsDevMeterRefreshResponse gmopsDevMeterRefreshResponse = new GmopsDevMeterRefreshResponse();
        gmopsDevMeterRefreshResponse.setFailureDefault();
        GmopsDevMeter gmopsDevMeter = null;
        GmopsDevMeterDo gmopsDevMeterDo = new GmopsDevMeterDo();
        if (gmopsDevMeterRefreshRequest != null && gmopsDevMeterRefreshRequest.getDevMeterId() != null && gmopsDevMeterRefreshRequest.getDevMeterId() > 0L) {
            QueryWrapper<GmopsDevMeter> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dev_meter_id", gmopsDevMeterRefreshRequest.getDevMeterId());
            gmopsDevMeter = gmopsDevMeterMapper.selectOne(queryWrapper);
        }
        if (gmopsDevMeter == null) {
            GmDevMeter gmDevMeter = null;
            if (gmopsDevMeterRefreshRequest != null && gmopsDevMeterRefreshRequest.getDevMeterId() != null && gmopsDevMeterRefreshRequest.getDevMeterId() > 0L) {
                gmDevMeter = gmDevMeterMapper.selectById(gmopsDevMeterRefreshRequest.getDevMeterId());
            }
            if (gmDevMeter != null) {
                gmopsDevMeter = new GmopsDevMeter();
                gmopsDevMeter.setDevMeterId(gmDevMeter.getId());
                gmopsDevMeter.setGmtMessageUp(gmopsDevMeterRefreshRequest.getGmtMessageUp() != null ? gmopsDevMeterRefreshRequest.getGmtMessageUp() : 0L);
                gmopsDevMeter.setGmtMeasdataUp(gmopsDevMeterRefreshRequest.getGmtMeasdataUp() != null ? gmopsDevMeterRefreshRequest.getGmtMeasdataUp() : 0L);
                gmopsDevMeter.setGmtAlarmUp(gmopsDevMeterRefreshRequest.getGmtAlarmUp() != null ? gmopsDevMeterRefreshRequest.getGmtAlarmUp() : 0L);
                gmopsDevMeter.setGmtReadingUp(gmopsDevMeterRefreshRequest.getGmtReadingUp() != null ? gmopsDevMeterRefreshRequest.getGmtReadingUp() : 0L);
                gmopsDevMeter.setReadingValue(gmopsDevMeterRefreshRequest.getReadingValue());
                gmopsDevMeter.setMeterStateOpen(gmopsDevMeterRefreshRequest.getMeterStateOpen() != null ? gmopsDevMeterRefreshRequest.getMeterStateOpen() : 0);
                gmopsDevMeter.setMeasDataInfoSet(gmopsDevMeterRefreshRequest.getMeasDataInfoSet() != null ? gmopsDevMeterRefreshRequest.getMeasDataInfoSet() : "{}");
                gmopsDevMeter.setIsValid(true);
                gmopsDevMeter.setCreator("IESMS_BP");
                gmopsDevMeter.setGmtCreate(System.currentTimeMillis());
                gmopsDevMeter.setModifier("IESMS_BP");
                gmopsDevMeter.setGmtModified(System.currentTimeMillis());
                gmopsDevMeter.setInvalider("");
                gmopsDevMeter.setGmtInvalid(0L);
                gmopsDevMeter.setVersion(1);
                gmopsDevMeterMapper.insert(gmopsDevMeter);
            }
        } else {
            if (gmopsDevMeterRefreshRequest.getGmtMessageUp() != null) {
                gmopsDevMeter.setGmtMessageUp(gmopsDevMeterRefreshRequest.getGmtMessageUp());
            }
            if (gmopsDevMeterRefreshRequest.getGmtMeasdataUp() != null) {
                gmopsDevMeter.setGmtMeasdataUp(gmopsDevMeterRefreshRequest.getGmtMeasdataUp());
            }
            if (gmopsDevMeterRefreshRequest.getGmtAlarmUp() != null) {
                gmopsDevMeter.setGmtAlarmUp(gmopsDevMeterRefreshRequest.getGmtAlarmUp());
            }
            if (gmopsDevMeterRefreshRequest.getGmtReadingUp() != null) {
                gmopsDevMeter.setGmtReadingUp(gmopsDevMeterRefreshRequest.getGmtReadingUp());
            }
            if (gmopsDevMeterRefreshRequest.getReadingValue() != null) {
                gmopsDevMeter.setReadingValue(gmopsDevMeterRefreshRequest.getReadingValue());
            }
            if (gmopsDevMeterRefreshRequest.getMeterStateOpen() != null) {
                gmopsDevMeter.setMeterStateOpen(gmopsDevMeterRefreshRequest.getMeterStateOpen());
            }
            if (gmopsDevMeterRefreshRequest.getMeasDataInfoSet() != null) {
                String getMeasDataInfoSetOld = gmopsDevMeter.getMeasDataInfoSet();
                String getMeasDataInfoSetNew = gmopsDevMeterRefreshRequest.getMeasDataInfoSet();
//                Map<String, Object> getMeasDataInfoSetOldMap = Convert.convert(Map.class, getMeasDataInfoSetOld);
//                Map<String, Object> getMeasDataInfoSetNewMap = Convert.convert(Map.class, getMeasDataInfoSetNew);
//                Map<String, Object> getMeasDataInfoSetMap = Maps.newHashMap();
//                if (getMeasDataInfoSetOldMap != null) {
//                    getMeasDataInfoSetMap.putAll(getMeasDataInfoSetOldMap);
//                }
//                if (getMeasDataInfoSetNewMap != null) {
//                    getMeasDataInfoSetMap.putAll(getMeasDataInfoSetNewMap);
//                }
                gmopsDevMeter.setMeasDataInfoSet(StrUtil.isEmpty(getMeasDataInfoSetNew)?getMeasDataInfoSetOld:getMeasDataInfoSetNew);
            }
            gmopsDevMeter.setModifier("IESMS_BP");
            gmopsDevMeter.setGmtModified(System.currentTimeMillis());
            gmopsDevMeterMapper.updateById(gmopsDevMeter);
        }
        assert gmopsDevMeter != null;
        BeanUtils.copyProperties(gmopsDevMeter, gmopsDevMeterDo);
        gmopsDevMeterRefreshResponse.setSuccess();
        gmopsDevMeterRefreshResponse.setGmopsDevMeter(gmopsDevMeterDo);
        return gmopsDevMeterRefreshResponse;
    }

    @Override
    public GmopsDevTermRefreshResponse refreshGmopsDevTerm(GmopsDevTermRefreshRequest gmopsDevTermRefreshRequest) {
        GmopsDevTermRefreshResponse gmopsDevTermRefreshResponse = new GmopsDevTermRefreshResponse();
        gmopsDevTermRefreshResponse.setFailureDefault();
        GmopsDevTerm gmopsDevTerm = null;
        GmopsDevTermDo gmopsDevTermDo = new GmopsDevTermDo();
        if (gmopsDevTermRefreshRequest != null && gmopsDevTermRefreshRequest.getDevTermId() != null && gmopsDevTermRefreshRequest.getDevTermId() > 0L) {
            QueryWrapper<GmopsDevTerm> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dev_term_id", gmopsDevTermRefreshRequest.getDevTermId());
            gmopsDevTerm = gmopsDevTermMapper.selectOne(queryWrapper);
        }
        if (gmopsDevTerm == null) {
            GmDevTerm gmDevTerm = null;
            if (gmopsDevTermRefreshRequest != null && gmopsDevTermRefreshRequest.getDevTermId() != null && gmopsDevTermRefreshRequest.getDevTermId() > 0L) {
                gmDevTerm = gmDevTermMapper.selectById(gmopsDevTermRefreshRequest.getDevTermId());
            }
            if (gmDevTerm != null) {
                gmopsDevTerm = new GmopsDevTerm();
                gmopsDevTerm.setDevTermId(gmDevTerm.getId());
                gmopsDevTerm.setGmtConnectedAt(gmopsDevTermRefreshRequest.getGmtConnectedAt() != null ? gmopsDevTermRefreshRequest.getGmtConnectedAt() : 0L);
                gmopsDevTerm.setGmtHeartbeatUp(gmopsDevTermRefreshRequest.getGmtHeartbeatUp() != null ? gmopsDevTermRefreshRequest.getGmtHeartbeatUp() : 0L);
                gmopsDevTerm.setGmtMessageUp(gmopsDevTermRefreshRequest.getGmtMessageUp() != null ? gmopsDevTermRefreshRequest.getGmtMessageUp() : 0L);
                gmopsDevTerm.setGmtMeasdataUp(gmopsDevTermRefreshRequest.getGmtMeasdataUp() != null ? gmopsDevTermRefreshRequest.getGmtMeasdataUp() : 0L);
                gmopsDevTerm.setGmtAlarmUp(gmopsDevTermRefreshRequest.getGmtAlarmUp() != null ? gmopsDevTermRefreshRequest.getGmtAlarmUp() : 0L);
                gmopsDevTerm.setIsValid(true);
                gmopsDevTerm.setCreator("IESMS_BP");
                gmopsDevTerm.setGmtCreate(System.currentTimeMillis());
                gmopsDevTerm.setModifier("IESMS_BP");
                gmopsDevTerm.setGmtModified(System.currentTimeMillis());
                gmopsDevTerm.setInvalider("");
                gmopsDevTerm.setGmtInvalid(0L);
                gmopsDevTerm.setVersion(1);
                gmopsDevTermMapper.insert(gmopsDevTerm);
            }
        } else {
            if (gmopsDevTermRefreshRequest.getGmtConnectedAt() != null) {
                gmopsDevTerm.setGmtConnectedAt(gmopsDevTermRefreshRequest.getGmtConnectedAt());
            }
            if (gmopsDevTermRefreshRequest.getGmtHeartbeatUp() != null) {
                gmopsDevTerm.setGmtHeartbeatUp(gmopsDevTermRefreshRequest.getGmtHeartbeatUp());
            }
            if (gmopsDevTermRefreshRequest.getGmtMessageUp() != null) {
                gmopsDevTerm.setGmtMessageUp(gmopsDevTermRefreshRequest.getGmtMessageUp());
            }
            if (gmopsDevTermRefreshRequest.getGmtMeasdataUp() != null) {
                gmopsDevTerm.setGmtMeasdataUp(gmopsDevTermRefreshRequest.getGmtMeasdataUp());
            }
            if (gmopsDevTermRefreshRequest.getGmtAlarmUp() != null) {
                gmopsDevTerm.setGmtAlarmUp(gmopsDevTermRefreshRequest.getGmtAlarmUp());
            }
            gmopsDevTerm.setModifier("IESMS_BP");
            gmopsDevTerm.setGmtModified(System.currentTimeMillis());
            gmopsDevTermMapper.updateById(gmopsDevTerm);
        }
        gmopsDevTermRefreshResponse.setSuccess();
        assert gmopsDevTerm != null;
        BeanUtils.copyProperties(gmopsDevTerm, gmopsDevTermDo);
        gmopsDevTermRefreshResponse.setGmopsDevTerm(gmopsDevTermDo);
        return gmopsDevTermRefreshResponse;
    }
}
