package com.gaea.iesms.bm.iot.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.iot.mapper.GmDevMeterMapper;
import com.gaea.iesms.bm.iot.model.request.AssocGmDevMeterRequest;
import com.gaea.iesms.bm.iot.model.request.GmDevMeterPageRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevMeterPageVo;
import com.gaea.iesms.bm.iot.model.response.GmDevMeterVo;
import com.gaea.iesms.bm.iot.service.GmDevMeterService;
import com.gaea.iesms.bm.iot.service.GmDevTermService;
import com.gaea.iesms.core.feign.dto.SysCodeSortDTO;
import com.gaea.iesms.core.feign.request.SysCodeSortQueryRequest;
import com.gaea.iesms.core.feign.response.iot.GmDevMeterTermVo;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.iot.GmDevMeter;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Administrator
 * @description 针对表【gm_dev_meter(量测表计设备 )】的数据库操作Service实现
 * @createDate 2023-03-27 08:55:25
 */
@Service
public class GmDevMeterServiceImpl extends ServiceImpl<GmDevMeterMapper, GmDevMeter>
        implements GmDevMeterService {

    @Resource
    private GmDevMeterMapper gmDevMeterMapper;

    @Resource
    private RemoteSystemService remoteSystemService;
    @Resource
    private GmDevTermService gmDevTermService;

    @Override
    public GmDevMeterPageVo selectGmDevMeterPage(GmDevMeterPageRequest request) {
        Page<GmDevMeterVo> page = new Page<>(request.getPageNumber(), request.getPageSize());
        String orgNo = AuthUtils.getOrgNo();
        QueryWrapper<GmDevMeterVo> queryWrapper = new QueryWrapper<GmDevMeterVo>()
                .like(StrUtil.isNotBlank(orgNo), "gdm.org_no", orgNo)
                .eq("gdm.is_valid", 1)
                .like(ObjectUtil.isNotEmpty(request.getDevTermNo()), "gdt.dev_term_no", request.getDevTermNo())
                .like(ObjectUtil.isNotEmpty(request.getDevTermCommAddr()), "gdt.dev_term_comm_addr", request.getDevTermCommAddr())
                .like(ObjectUtil.isNotEmpty(request.getDevMeterNo()), "gdm.dev_meter_no", request.getDevMeterNo())
                .like(ObjectUtil.isNotEmpty(request.getDevMeterCommAddr()), "gdm.dev_meter_comm_addr", request.getDevMeterCommAddr())
                .eq(ObjectUtil.isNotEmpty(request.getDevMeterStatus()), "gdm.dev_meter_status", request.getDevMeterStatus())
                .like(StrUtil.isNotEmpty(request.getDevMeterName()), "gdm.dev_meter_name", request.getDevMeterName())
                .eq(ObjectUtil.isNotEmpty(request.getModelCode()), "gdm.model_code", request.getModelCode())
                .eq(ObjectUtil.isNotEmpty(request.getCeCustId()), "ipmcr.ce_res_id", request.getCeCustId())
                .eq(StrUtil.isNotEmpty(request.getDevMeterType()), "gdm.dev_meter_type", request.getDevMeterType())
                .groupBy("gdm.id")
                .orderByDesc("gdm.gmt_create");
        IPage<GmDevMeterVo> iPage = gmDevMeterMapper.selectGmDevMeterPage(page, queryWrapper);
        List<GmDevMeterVo> list = iPage.getRecords();
        long total = iPage.getTotal();
        list.forEach(item -> {
            item.setDevMeterRunParam(ObjectUtil.isNotEmpty(item.getDevMeterRunParam()) ? JSONUtil.parseObj(item.getDevMeterRunParam()) : "{}");
            SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
            sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_METER_MFR_CODE");
            sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
            R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);
            if (mapR.isSuccess()) {
                item.setMfrName(ObjectUtil.isEmpty(mapR.getData().get(item.getMfrCode()))
                        || StrUtil.isEmpty(mapR.getData().get(item.getMfrCode()).getCodeName()) ? null : mapR.getData().get(item.getMfrCode()).getCodeName());
            }
        });

        GmDevMeterPageVo gmDevMeterPageVo = new GmDevMeterPageVo();
        gmDevMeterPageVo.setList(list);
        gmDevMeterPageVo.setTotal(total);
        return gmDevMeterPageVo;
    }

    @Override
    public GmDevMeterPageVo getAssocGmDevMeterList(AssocGmDevMeterRequest request) {
        request.setOrgNo(AuthUtils.getOrgNo());
        int x = request.getPageNumber() == 0 ? 1 : request.getPageNumber();
        int y = request.getPageSize() == 0 ? 10 : request.getPageSize();
        request.setPageNumber((x - 1) * y);
        request.setPageSize(y);
        List<GmDevMeterVo> list = gmDevMeterMapper.getAssocGmDevMeterList(request);
        request.setPageNumber(0);
        request.setPageSize(Integer.MAX_VALUE);
        List<GmDevMeterVo> list1 = gmDevMeterMapper.getAssocGmDevMeterList(request);
        GmDevMeterPageVo gmDevMeterPageVo = new GmDevMeterPageVo();
        gmDevMeterPageVo.setList(list);
        gmDevMeterPageVo.setTotal((long) list1.size());
        return gmDevMeterPageVo;
    }

    @Override
    public GmDevMeter getGmDevMeterByResId(AssocGmDevMeterRequest request) {
        return gmDevMeterMapper.getGmDevMeterByResId(request);
    }

    @Override
    public String getGmtMessageUp(String measPointId) {
        return gmDevMeterMapper.getGmtMessageUp(measPointId);
    }

    @Override
    public List<GmDevMeterTermVo> getDevTermMeterList(List<String> meterIds) {
        List<GmDevMeterTermVo> gmDevMeterTermVos = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(meterIds)) {
            List<GmDevMeter> gmDevMeters = this.listByIds(meterIds);
            if (CollectionUtil.isNotEmpty(gmDevMeters)) {
                List<Long> accessGatewayIds = gmDevMeters.stream().map(GmDevMeter::getAccessGatewayId).collect(Collectors.toList());
                List<GmDevTerm> gmDevTerms = gmDevTermService.list(new LambdaQueryWrapper<GmDevTerm>().in(GmDevTerm::getAccessGatewayId, accessGatewayIds));
                Map<Long, List<GmDevTerm>> gmDevTermMap = gmDevTerms.stream().collect(Collectors.groupingBy(GmDevTerm::getAccessGatewayId));
                gmDevMeters.forEach(gmDevMeter -> {
                    GmDevMeterTermVo gmDevMeterTermVo = new GmDevMeterTermVo();
                    gmDevMeterTermVo.setDevMeterId(String.valueOf(gmDevMeter.getId()));
                    gmDevMeterTermVo.setDevMeterNo(gmDevMeter.getDevMeterNo());
                    gmDevMeterTermVo.setDevMeterCommAddr(gmDevMeter.getDevMeterCommAddr());
                    gmDevMeterTermVo.setMeasPointId(String.valueOf(gmDevMeter.getMeasPointId()));
                    if (CollectionUtil.isNotEmpty(gmDevTermMap.get(gmDevMeter.getAccessGatewayId()))) {
                        GmDevTerm gmDevTerm = gmDevTermMap.get(gmDevMeter.getAccessGatewayId()).get(0);
                        gmDevMeterTermVo.setDevTermId(String.valueOf(gmDevTerm.getId()));
                        gmDevMeterTermVo.setDevTermNo(gmDevTerm.getDevTermNo());
                        gmDevMeterTermVo.setDevTermCommAddr(gmDevTerm.getDevTermCommAddr());
                    }
                    gmDevMeterTermVos.add(gmDevMeterTermVo);
                });
            }
        }
        return gmDevMeterTermVos;
    }
}




