package com.gaea.iesms.bm.iot.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.iot.mapper.GmDevTermMapper;
import com.gaea.iesms.bm.iot.model.request.GmDevTermPageRequest;
import com.gaea.iesms.bm.iot.model.response.GmDevTermPageVo;
import com.gaea.iesms.bm.iot.model.response.GmDevTermVo;
import com.gaea.iesms.bm.iot.service.GmDevTermService;
import com.gaea.iesms.core.feign.dto.SysCodeSortDTO;
import com.gaea.iesms.core.feign.request.SysCodeSortQueryRequest;
import com.gaea.iesms.core.feign.service.RemoteSystemService;
import com.gaea.iesms.core.model.entity.iot.GmDevTerm;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 采集终端设备
 *
 * @author admin
 */
@Service
public class GmDevTermServiceImpl extends ServiceImpl<GmDevTermMapper, GmDevTerm>
        implements GmDevTermService {

    @Resource
    private GmDevTermMapper gmDevTermMapper;

    @Resource
    private RemoteSystemService remoteSystemService;

    @Override
    public GmDevTermPageVo selectGmDevTermPage(GmDevTermPageRequest request) {
        Page<GmDevTermVo> page = new Page<>(request.getPageNumber(), request.getPageSize());
        String orgNo = AuthUtils.getOrgNo();
        QueryWrapper<GmDevTermVo> queryWrapper = new QueryWrapper<GmDevTermVo>()
                .like(StrUtil.isNotBlank(orgNo), "gdt.org_no", orgNo)
                .eq("gdt.is_valid", 1)
                .like(StrUtil.isNotEmpty(request.getDevTermName()), "gdt.dev_term_name", request.getDevTermName())
                .like(ObjectUtil.isNotEmpty(request.getDevTermNo()), "gdt.dev_term_no", request.getDevTermNo())
                .eq(ObjectUtil.isNotEmpty(request.getDevTermStatus()), "gdt.dev_term_status", request.getDevTermStatus())
                .like(ObjectUtil.isNotEmpty(request.getDevTermCommAddr()), "gdt.dev_term_comm_addr", request.getDevTermCommAddr())
                .eq(ObjectUtil.isNotEmpty(request.getModelCode()), "gdt.model_code", request.getModelCode())
                .eq(ObjectUtil.isNotEmpty(request.getDevTermId()), "gdt.id", request.getDevTermId())
                .eq(ObjectUtil.isNotEmpty(request.getCeCustId()), "iptcr.ce_res_id", request.getCeCustId())
                .like(StrUtil.isNotEmpty(request.getCeCustName()), "cr.ce_res_name", request.getCeCustName())
                .groupBy("gdt.id")
                .orderByDesc("gdt.gmt_create");
        IPage<GmDevTermVo> iPage = gmDevTermMapper.selectGmDevTermPage(page, queryWrapper);
        List<GmDevTermVo> list = iPage.getRecords();
        list.forEach(item -> {
            //判断终端是否关联表计
            QueryWrapper<GmDevTermVo> queryWrapper1 = new QueryWrapper<GmDevTermVo>()
                    .eq("gdt.id", item.getId());
            List<String> devTermCommAddrByIds = gmDevTermMapper.getDevTermCommAddrByIds(queryWrapper1);
            item.setAssocMeter(CollectionUtil.isNotEmpty(devTermCommAddrByIds) ? "是" : "否");

            SysCodeSortQueryRequest sysCodeSortQueryRequest = new SysCodeSortQueryRequest();
            sysCodeSortQueryRequest.setCodeSortNo("EMS_DEV_TERM_MFR_CODE");
            sysCodeSortQueryRequest.setProjectCode("EMS_CODE");
            R<Map<String, SysCodeSortDTO>> mapR = remoteSystemService.queryCodeSort(sysCodeSortQueryRequest);
            if (mapR.isSuccess()) {
                item.setMfrName(ObjectUtil.isEmpty(mapR.getData().get(item.getMfrCode()))
                        || StrUtil.isEmpty(mapR.getData().get(item.getMfrCode()).getCodeName()) ? null : mapR.getData().get(item.getMfrCode()).getCodeName());
            }
        });

        long total = iPage.getTotal();
        GmDevTermPageVo gmDevTermPageVo = new GmDevTermPageVo();
        gmDevTermPageVo.setList(list);
        gmDevTermPageVo.setTotal(total);
        return gmDevTermPageVo;
    }

    @Override
    public List<String> getDevTermCommAddrByIds(QueryWrapper<GmDevTermVo> queryWrapper) {
        return gmDevTermMapper.getDevTermCommAddrByIds(queryWrapper);
    }
}




