package com.gaea.iesms.bm.iot.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.iesms.bm.iot.mapper.GmopsDevTermMapper;
import com.gaea.iesms.core.feign.response.iot.GmopsDevTermDataInfo;
import com.gaea.iesms.bm.iot.service.GmopsDevTermService;
import com.gaea.iesms.core.feign.request.iot.GmopsDevTermDataRequest;
import com.gaea.iesms.core.model.entity.iot.GmopsDevTerm;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 采集终端设备工况
 */
@Service
public class GmopsDevTermServiceImpl extends ServiceImpl<GmopsDevTermMapper, GmopsDevTerm>
        implements GmopsDevTermService {

    @Resource
    private GmopsDevTermMapper gmopsDevTermMapper;

    @Override
    public Map<Long, GmopsDevTermDataInfo> getTermGmopsDataInfo(GmopsDevTermDataRequest request) {
        request.setOrgNo(AuthUtils.getOrgNo());
        List<GmopsDevTermDataInfo> dataList = gmopsDevTermMapper.selectTermGmopsDataInfo(request);
        return dataList.stream().collect(Collectors.toMap(GmopsDevTermDataInfo::getCeResId, Function.identity(), (v1, v2) -> v2));
    }
}
