package com.gaea.iesms.bm.iot.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.generator.SnowflakeGenerator;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.base.core.R;
import com.gaea.base.error.BizException;
import com.gaea.iesms.bm.iot.mapper.*;
import com.gaea.iesms.bm.iot.model.request.GmDevTermRequest;
import com.gaea.iesms.bm.iot.model.request.InstCeResourceRequest;
import com.gaea.iesms.bm.iot.model.request.SaveTermCeResourceRequest;
import com.gaea.iesms.bm.iot.model.request.SaveTermMeterRequest;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceMeterVo;
import com.gaea.iesms.bm.iot.model.response.InstCeResourcePageVo;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceTermVo;
import com.gaea.iesms.bm.iot.model.response.InstCeResourceVo;
import com.gaea.iesms.bm.iot.service.InstCeResourceService;
import com.gaea.iesms.core.feign.request.datacenter.AddTermMeterRequest;
import com.gaea.iesms.core.feign.response.datacenter.BrushMeterResponse;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.model.entity.iot.*;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.google.common.collect.Maps;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author admin
 */
@Service
public class InstCeResourceServiceImpl implements InstCeResourceService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource
    private InstCeResourceMapper instCeResourceMapper;

    @Resource
    private GmDevTermMapper gmDevTermMapper;

    @Resource
    private GmDevMeterMapper gmDevMeterMapper;

    @Resource
    private InstPointTermCeResourceMapper instPointTermCeResourceMapper;

    @Resource
    private InstPointMeterCeResourceMapper instPointMeterCeResourceMapper;

    @Resource
    private LogDevMeterChangeMapper logDevMeterChangeMapper;

    @Resource
    private LogDevMeterInstallMapper logDevMeterInstallMapper;

    @Resource
    private LogDevMeterDismantleMapper logDevMeterDismantleMapper;

    @Resource
    private DataCenterCommonService dataCenterCommonService;

    @Resource
    private LogTermChangeMapper logTermChangeMapper;

    private static final SnowflakeGenerator SNOWFLAKE_GENERATOR = new SnowflakeGenerator();

    @Override
    public InstCeResourcePageVo selectInstCeResourcePage(InstCeResourceRequest request) {
        Page<InstCeResourceVo> page = new Page<>(request.getPageNumber(), request.getPageSize());
        String orgNo = AuthUtils.getOrgNo();
        //Long userId = AuthUtils.getUserId();
        QueryWrapper<InstCeResourceVo> queryWrapper = new QueryWrapper<InstCeResourceVo>()
                .like(StrUtil.isNotBlank(orgNo), "cr.org_no", orgNo)
                .eq("cr.ce_res_status", 20)
                .eq("cr.is_valid", 1)
                .like(StrUtil.isNotBlank(request.getUsername()), "cr.ce_res_name", request.getUsername())
                .eq(StrUtil.isNotBlank(request.getTreeId()), "cc.id", request.getTreeId())
                .like(StrUtil.isNotBlank(request.getUserNo()), "cr.ce_res_no", request.getUserNo());
        IPage<InstCeResourceVo> iPage = instCeResourceMapper.selectInstCeResourcePage(page, queryWrapper);
        List<InstCeResourceVo> records = iPage.getRecords();
        records.forEach(item -> {
            //查看用户下是否挂有终端
            InstCeResourceRequest request1 = new InstCeResourceRequest();
            request1.setTreeId(item.getUserId());
            List<InstCeResourceTermVo> termList = selectInstCeResourceTermList(request1);
            boolean flag = termList.size() > 0;
            item.setHasChildren(flag);
            item.setParent(new ArrayList<>());
        });
        InstCeResourcePageVo pageVo = new InstCeResourcePageVo();
        pageVo.setList(records);
        pageVo.setTotal(iPage.getTotal());
        return pageVo;
    }

    @Override
    public List<InstCeResourceTermVo> selectInstCeResourceTermList(InstCeResourceRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        request.setOrgNo(orgNo);
        boolean attached = request.isAttached();
        List<InstCeResourceTermVo> termList;
        if (attached) {
            termList = instCeResourceMapper.selectInstCeResourceTermList(request);
        } else {
            termList = instCeResourceMapper.queryTerminalByUser(request);
        }
        termList.forEach(item -> {
            String termAccessGatewayId = item.getTermAccessGatewayId();
            String termId = item.getTermId();
            List<String> list = instCeResourceMapper.queryMeterTotalByTermId(termAccessGatewayId, request.getTreeId());
            boolean flag = list.size() > 0;
            item.setHasChildren(flag);
            String parentUserId = instCeResourceMapper.queryTermUpperNode(termId, "");
            if (StrUtil.isNotBlank(parentUserId)) {
                item.setParent(Collections.singletonList(parentUserId));
                item.setAssembly(true);
            } else {
                item.setParent(new ArrayList<>());
            }
        });
        return termList;
    }

    @Override
    public List<InstCeResourceMeterVo> selectInstCeResourceMeterList(InstCeResourceRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        request.setOrgNo(orgNo);
        boolean attached = request.isAttached();
        List<InstCeResourceMeterVo> meterList;
        if (attached) {
            meterList = instCeResourceMapper.selectInstCeResourceMeterList(request);
        } else {
            //查询终端下装接表计的信息
            meterList = instCeResourceMapper.queryMeterByTerminalOnIsAttached(request);
        }
        meterList.forEach(item -> {
            String meterId = item.getMeterId();
            if (StrUtil.isNotBlank(meterId)) {
                InstCeResourceVo instCeResourceVo = instCeResourceMapper.selectUserTermByMeter(meterId);
                if (ObjectUtil.isNotEmpty(instCeResourceVo)) {
                    String parentUserId = instCeResourceVo.getUserId();
                    String parentTermId = instCeResourceVo.getTermId();
                    if (StrUtil.isNotBlank(parentUserId) && StrUtil.isNotBlank(parentTermId)) {
                        List<String> parent = new ArrayList<>();
                        parent.add(parentUserId);
                        parent.add(parentTermId);
                        item.setParent(parent);
                    }
                }
            } else {
                item.setParent(Lists.newArrayList());
            }
        });
        return meterList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public R addPointTermCeResource(SaveTermCeResourceRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        String userNo = AuthUtils.getUserNo();
        request.setOrgNo(orgNo);
        request.setUserNo(userNo);
        //终端id
        String termId = request.getTermId();
        //用户id
        String resId = "0";
        logger.info("addPointTermCeResource参数：" + request);

        //判断终端地址不能为空
        if (StrUtil.isBlank(request.getDevTermAddr())) {
            return R.failure().msg("采集通信终端地址不能为空");
        }

        //找到终端网关id
        QueryWrapper<GmDevTerm> queryWrapper = new QueryWrapper<GmDevTerm>()
                .like(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                .eq("id", termId);
        GmDevTerm gmDevTerm = gmDevTermMapper.selectOne(queryWrapper);

        logger.info("gmDevTerm：" + gmDevTerm);

        if (StrUtil.isNotBlank(request.getDevTermAddr())) {
            if (!StrUtil.equals(request.getDevTermAddr(), gmDevTerm.getDevTermCommAddr())) {
                QueryWrapper<GmDevTerm> queryWrapper1 = new QueryWrapper<GmDevTerm>()
                        .eq(StrUtil.isNotBlank(orgNo), "org_no", orgNo)
                        .eq("dev_term_comm_addr", request.getDevTermAddr());
                long devTermCommAddrCount = gmDevTermMapper.selectList(queryWrapper1).stream()
                        .filter(e -> e.getDevTermCommAddr() != null && e.getDevTermCommAddr().equals(request.getDevTermAddr())).count();
                if (devTermCommAddrCount > 0) {
                    return R.failure().msg("采集通信终端地址已重复");
                }
            }
        }


        String accessGatewayId;
        if (ObjectUtil.isNotEmpty(gmDevTerm)) {
            accessGatewayId = String.valueOf(gmDevTerm.getAccessGatewayId());
        } else {
            accessGatewayId = request.getTermAccessGatewayId();
        }

        String parentUserId = instCeResourceMapper.queryTermUpperNode(termId, resId);
        if (StrUtil.isNotBlank(parentUserId)) {
            return R.failure().msg("该用户已装接该终端");
        } else {
            //查询终端下已经装接的表计→这些表计是否又装接了用户，如果没装接去装接用户和表计关系
            List<String> meterId = instCeResourceMapper.selectMeterByTermAccessGatewayId(accessGatewayId);
            if (CollectionUtil.isNotEmpty(meterId)) {
                meterId.forEach(item -> {
                    InstPointMeterCeResource instResource = new InstPointMeterCeResource()
                            .setOrgNo(orgNo)
                            .setCeResClass(1)
                            .setCeResId(Long.valueOf(resId))
                            .setDevMeterId(Long.valueOf(item));
                    instPointMeterCeResourceMapper.insert(instResource);
                });
            }
            //新增终端和资源关系
            InstPointTermCeResource instPointTermCeResource = new InstPointTermCeResource()
                    .setOrgNo(orgNo)
                    .setCeResId(Long.valueOf(resId))
                    .setCeResClass(1)
                    .setDevTermId(Long.valueOf(termId));
            int i1 = instPointTermCeResourceMapper.insert(instPointTermCeResource);
            //更新终端状态
            GmDevTerm gmTerm = new GmDevTerm();
            gmTerm.setId(Long.valueOf(termId));
            gmTerm.setDevTermStatus(3);
            gmTerm.setDevTermCommAddr(request.getDevTermAddr());
            gmTerm.setDevTermName(request.getDevTermName());
            gmTerm.setSimNo(request.getSimNo());
            gmTerm.setGotorunner(userNo);
            gmTerm.setInstallRemark(request.getInstallRemark());
            gmTerm.setGotorunTime(DateUtil.date());
            gmTerm.setInstallTime(DateUtil.date());
            gmTerm.setInstaller(userNo);
            int i2 = gmDevTermMapper.updateById(gmTerm);
            if (i1 > 0 && i2 > 0) {
                return R.ok().msg("新增成功");
            } else {
                return R.failure().msg("新增失败");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public R addPointTermMeter(SaveTermMeterRequest request) {
        request.setCeResId("0");
        String orgNo = AuthUtils.getOrgNo();
        String userNo = AuthUtils.getUserNo();
        request.setOrgNo(orgNo);
        request.setUserNo(userNo);
        int mountingCount = instCeResourceMapper.selectMountingTermByMeterAddr("", request.getMeterId(), "");
        if (mountingCount > 0) {
            return R.failure().msg("表计已被装接");
        }

        //表计地址
        String meterAddr = request.getMeterAddr();
        //判断表计地址不能为空
        if (StrUtil.isBlank(meterAddr)) {
            return R.failure().msg("量测设备地址不能为空");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("gen_watt_paet", request.getElectricityTotal());
        jsonObject.set("gen_watt_paet1", request.getTop());
        jsonObject.set("gen_watt_paet2", request.getPeak());
        jsonObject.set("gen_watt_paet3", request.getFlat());
        jsonObject.set("gen_watt_paet4", request.getValley());
        request.setDevMeterStartReadingInfo(jsonObject.toString());


        //量测通信地址--同一个终端下不允许重复
        InstCeResourceRequest instCeResourceRequest = new InstCeResourceRequest();
        instCeResourceRequest.setCeResId(request.getCeResId());
        instCeResourceRequest.setTermId(request.getDevTermId());
        List<InstCeResourceMeterVo> meterVos = selectInstCeResourceMeterList(instCeResourceRequest);
        GmDevMeter gmDevMeter = gmDevMeterMapper.selectById(request.getMeterId());
        if (StrUtil.isNotBlank(meterAddr)) {
            if (!StrUtil.equals(meterAddr, gmDevMeter.getDevMeterCommAddr())) {
                //meterVos 里是否包含该量测设备
                long meterAddrCount = meterVos.stream()
                        .filter(e -> e.getDevMeterCommAddr() != null && e.getDevMeterCommAddr().equals(meterAddr)).count();
                if (meterAddrCount > 0) {
                    return R.failure().msg("量测设备地址已重复");
                }
            }
        }

        //调用数据中心接口
        GmDevTerm gmDevTerm = gmDevTermMapper.selectById(request.getDevTermId());

        AddTermMeterRequest addTermMeterRequest = new AddTermMeterRequest();
        addTermMeterRequest.setDevTermNo(gmDevTerm.getDevTermNo());
        addTermMeterRequest.setDevMeterNo(gmDevMeter.getDevMeterNo());
        addTermMeterRequest.setDevTermAddr(gmDevTerm.getDevTermCommAddr());
        addTermMeterRequest.setDevMeterAddr(meterAddr);
        addTermMeterRequest.setDevMeterCommProto(gmDevMeter.getDevMeterCommProto());
        logger.info("装接终端和表计参数：" + addTermMeterRequest);


        R<BrushMeterResponse> r = dataCenterCommonService.addTermMeter(addTermMeterRequest);
        logger.info("装接终端和表计返回值：" + r);
        if (r.getCode() != 200) {
            return R.failure().msg(r.getMsg());
        }
        //修改表计
        request.setDevMeterStatus("3");
        request.setDevMeterName(request.getDevMeterName());
        request.setDevMeterType(request.getDevMeterType());
        request.setMeterAddr(meterAddr);
        request.setSelfRate(request.getSelfRate());
        request.setCtRate(request.getCtRate());
        request.setPtRate(request.getPtRate());
        request.setMeasPointId(r.getData().getRunMeasPointId());
        request.setAccessMeasureId(r.getData().getAccessMeasureId());
        updateMeterById(request);
        //新增表计和资源关系
        InstPointMeterCeResource instResource = new InstPointMeterCeResource()
                .setOrgNo(orgNo)
                .setCeResClass(1)
                .setCeResId(Long.valueOf(request.getCeResId()))
                .setDevMeterId(Long.valueOf(request.getMeterId()));
        int i1 = instPointMeterCeResourceMapper.insert(instResource);
        //新增表计日志表
        int i2 = logDevMeterInstall(request);
        if (i1 > 0 && i2 > 0) {
            return R.ok().msg("新增成功");
        } else {
            return R.failure().msg("新增失败");
        }
    }

    @Override
    public int updateBatchInstCeResource(SaveTermMeterRequest request) {
        R r = addPointTermMeter(request);
        if (r.isSuccess()) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertBatchInstCeResource(SaveTermMeterRequest request) {
        //新增终端资源关系
        InstPointTermCeResource instPointTermCeResource = new InstPointTermCeResource()
                .setOrgNo(request.getOrgNo())
                .setCeResId(Long.valueOf(request.getCeResId()))
                .setCeResClass(1)
                .setDevTermId(Long.valueOf(request.getDevTermId()));
        int i1 = instPointTermCeResourceMapper.insert(instPointTermCeResource);
        //更新终端状态
        GmDevTerm gmTerm = new GmDevTerm();
        gmTerm.setId(Long.valueOf(request.getDevTermId()));
        gmTerm.setDevTermStatus(3);
        gmTerm.setGotorunner(request.getUserNo());
        gmTerm.setGotorunTime(DateUtil.date());
        gmTerm.setInstallTime(DateUtil.date());
        gmTerm.setInstaller(request.getUserNo());
        int i2 = gmDevTermMapper.updateById(gmTerm);
        //调用数据中心接口
        GmDevTerm gmDevTerm = gmDevTermMapper.selectById(request.getDevTermId());
        GmDevMeter gmDevMeter = gmDevMeterMapper.selectById(request.getMeterId());
        AddTermMeterRequest addTermMeterRequest = new AddTermMeterRequest();
        addTermMeterRequest.setDevTermNo(gmDevTerm.getDevTermNo());
        addTermMeterRequest.setDevMeterNo(gmDevMeter.getDevMeterNo());
        addTermMeterRequest.setDevTermAddr(gmDevTerm.getDevTermCommAddr());
        addTermMeterRequest.setDevMeterAddr(request.getMeterAddr());
        addTermMeterRequest.setDevMeterCommProto(gmDevMeter.getDevMeterCommProto());
        logger.info("批量装接终端和表计参数：" + addTermMeterRequest);
        R<BrushMeterResponse> r = dataCenterCommonService.addTermMeter(addTermMeterRequest);
        logger.info("批量装接终端和表计返回值：" + r);
        if (r.isSuccess()) {
            request.setMeasPointId(r.getData().getRunMeasPointId());
            request.setAccessMeasureId(r.getData().getAccessMeasureId());
        }
        //更新表计信息
        request.setDevMeterStatus("3");
        updateMeterById(request);
        //新增表计和资源关系
        InstPointMeterCeResource instResource = new InstPointMeterCeResource()
                .setOrgNo(request.getOrgNo())
                .setCeResClass(1)
                .setCeResId(Long.valueOf(request.getCeResId()))
                .setDevMeterId(Long.valueOf(request.getMeterId()));
        int i3 = instPointMeterCeResourceMapper.insert(instResource);
        //新增表计日志
        int i4 = logDevMeterInstall(request);
        if (i1 == 1 && i2 == 1 && i3 == 1 && i4 == 1 && r.isSuccess()) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public R updatePointTermMeter(SaveTermMeterRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        String userNo = AuthUtils.getUserNo();
        request.setOrgNo(orgNo);
        request.setUserNo(userNo);
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("gen_watt_paet", request.getElectricityTotal());
        jsonObject.set("gen_watt_paet1", request.getTop());
        jsonObject.set("gen_watt_paet2", request.getPeak());
        jsonObject.set("gen_watt_paet3", request.getFlat());
        jsonObject.set("gen_watt_paet4", request.getValley());
        request.setDevMeterStartReadingInfo(jsonObject.toString());
        JSONObject newJsonObject = new JSONObject();
        newJsonObject.set("gen_watt_paet", request.getNewElectricityTotal());
        newJsonObject.set("gen_watt_paet1", request.getNewTop());
        newJsonObject.set("gen_watt_paet2", request.getNewPeak());
        newJsonObject.set("gen_watt_paet3", request.getNewFlat());
        newJsonObject.set("gen_watt_paet4", request.getNewValley());
        request.setNewDevMeterStartReadingInfo(newJsonObject.toString());

        String meterAddr = request.getMeterAddr();
        //量测通信地址--同一个终端下不允许重复
        InstCeResourceRequest instCeResourceRequest = new InstCeResourceRequest();
        instCeResourceRequest.setCeResId(request.getCeResId());
        instCeResourceRequest.setTermId(request.getDevTermId());
        List<InstCeResourceMeterVo> meterVos = selectInstCeResourceMeterList(instCeResourceRequest);
        GmDevMeter gmDevMeterVo = gmDevMeterMapper.selectById(request.getMeterId());
        if (StrUtil.isNotBlank(meterAddr)) {
            if (!StrUtil.equals(meterAddr, gmDevMeterVo.getDevMeterCommAddr())) {
                //meterVos 里是否包含该量测设备
                long meterAddrCount = meterVos.stream()
                        .filter(e -> e.getDevMeterCommAddr() != null && e.getDevMeterCommAddr().equals(meterAddr)).count();
                if (meterAddrCount > 0) {
                    return R.failure().msg("量测设备地址已重复");
                }
            }
        }

        //网关标识
        String termAccessGatewayId = request.getTermAccessGatewayId();
        //更改老的表计状态为已拆除
        GmDevMeter gmDevMeterOld = gmDevMeterMapper.selectById(request.getMeterId());
        gmDevMeterOld.setDevMeterStatus(7);
        gmDevMeterMapper.updateById(gmDevMeterOld);

        //删除用户和老表计的关系
        deleteInstPointMeterCeResource(request.getMeterId());
        //更改新的装接
        GmDevMeter gmDevMeter = new GmDevMeter();
        gmDevMeter.setId(Long.valueOf(request.getNewMeterId()));
        gmDevMeter.setDevMeterName(request.getDevMeterName());
        gmDevMeter.setDevMeterStatus(3);
        gmDevMeter.setDevMeterCommAddr(request.getMeterAddr());
        gmDevMeter.setSelfRate(request.getSelfRate());
        gmDevMeter.setCtRate(request.getCtRate());
        gmDevMeter.setPtRate(request.getPtRate());
        gmDevMeter.setDevMeterType(Integer.valueOf(request.getDevMeterType()));
        gmDevMeter.setAccessGatewayId(StrUtil.isNotBlank(termAccessGatewayId) ? Long.valueOf(termAccessGatewayId) : null);
        gmDevMeterMapper.updateById(gmDevMeter);
        //新增用户和表计的关系（为了确定某个表计到底在哪个用户下装接的）
        InstPointMeterCeResource instResource = new InstPointMeterCeResource()
                .setOrgNo(orgNo)
                .setCeResClass(1)
                .setCeResId(Long.valueOf(request.getCeResId()))
                .setDevMeterId(Long.valueOf(request.getNewMeterId()));
        int i1 = instPointMeterCeResourceMapper.insert(instResource);
        int i2 = logDevMeterChange(request);
        if (i1 > 0 && i2 > 0) {
            return R.ok().msg("编辑成功");
        } else {
            return R.failure().msg("编辑失败");
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replaceGmDevTerm(GmDevTermRequest request) {
        //老终端id
        String oldTermId = request.getOldTermId();
        //修改老终端状态为已拆除
        GmDevTerm gmDevTerm = gmDevTermMapper.selectById(oldTermId);
        gmDevTerm.setDevTermStatus(7);
        gmDevTerm.setDismantleTime(DateUtil.date());
        gmDevTerm.setDismantler(AuthUtils.getUserNo());
        gmDevTermMapper.updateById(gmDevTerm);
        //新终端id
        Long id = request.getId();
        //修改新终端状态为已投运，同步接入网关设备标识
        GmDevTerm newGmDevTerm = gmDevTermMapper.selectById(id);

        if (StrUtil.isNotBlank(request.getDevTermCommAddr())) {
            if (!StrUtil.equals(request.getDevTermCommAddr(), newGmDevTerm.getDevTermCommAddr())) {
                QueryWrapper<GmDevTerm> queryWrapper1 = new QueryWrapper<GmDevTerm>()
                        .eq("dev_term_comm_addr", request.getDevTermCommAddr());
                long devTermCommAddrCount = gmDevTermMapper.selectList(queryWrapper1).stream()
                        .filter(e -> e.getDevTermCommAddr() != null && e.getDevTermCommAddr().equals(request.getDevTermCommAddr())).count();
                if (devTermCommAddrCount > 0) {
                    throw BizException.of("采集通信终端地址已重复");
                }
            }
        }

        newGmDevTerm.setDevTermStatus(3);
        newGmDevTerm.setDevTermCommAddr(request.getDevTermCommAddr());
        newGmDevTerm.setInstallRemark(request.getInstallRemark());
        newGmDevTerm.setAccessGatewayId(gmDevTerm.getAccessGatewayId());
        newGmDevTerm.setMeasPointId(gmDevTerm.getMeasPointId());
        gmDevTermMapper.updateById(newGmDevTerm);

        //更改装接关系
        InstPointTermCeResource instPointTermCeResource = new InstPointTermCeResource();
        instPointTermCeResource.setDevTermId(id);
        LambdaQueryWrapper<InstPointTermCeResource> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(InstPointTermCeResource::getDevTermId, Long.valueOf(oldTermId));
        instPointTermCeResourceMapper.update(instPointTermCeResource, queryWrapper);

        //新增更换终端日志
        LogTermChange logTermChange = new LogTermChange();
        logTermChange.setId(SNOWFLAKE_GENERATOR.next());
        logTermChange.setOldDevTermId(Long.parseLong(oldTermId));
        logTermChange.setNewDevTermId(id);
        logTermChange.setType("change");
        logTermChange.setChangTime(DateUtil.date());
        logTermChange.setHandleStatus(1);
        logTermChange.setHandleResult(1);
        logTermChange.setCreator(AuthUtils.getUserNo());
        logTermChange.setGmtCreate(System.currentTimeMillis());
        logTermChangeMapper.insert(logTermChange);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public R deletePointTermCeResource(SaveTermCeResourceRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        String userNo = AuthUtils.getUserNo();
        request.setOrgNo(orgNo);
        request.setUserNo(userNo);
        //网关标识
        String termAccessGatewayId = request.getTermAccessGatewayId();
        //用户下是否关联表计
        List<String> meterIds = instCeResourceMapper.queryMeterTotalByTermId(termAccessGatewayId, request.getResId());
        //删除用户和终端关系
        if (CollectionUtil.isNotEmpty(meterIds)) {
            delPointTermCeResource(request.getInstPointTermId(), meterIds);
            //更新表计表状态为已拆除
            meterIds.forEach(item -> {
                GmDevMeter gmDevMeter = new GmDevMeter();
                gmDevMeter.setId(Long.valueOf(item));
                gmDevMeter.setDevMeterStatus(7);
                gmDevMeter.setAccessGatewayId(0L);
                gmDevMeter.setDismantler(userNo);
                gmDevMeter.setDismantleTime(DateUtil.date());
                gmDevMeterMapper.updateById(gmDevMeter);
            });
        } else {
            delPointTermCeResource(request.getInstPointTermId(), null);
        }
        String userId = instCeResourceMapper.queryTermUpperNode(request.getTermId(), "");
        //如该终端没有关联用户，则更改终端状态
        if (StrUtil.isBlank(userId)) {
            //更新终端状态
            GmDevTerm gmTerm = new GmDevTerm();
            gmTerm.setId(Long.valueOf(request.getTermId()));
            gmTerm.setDevTermStatus(7);
            gmTerm.setDismantleTime(DateUtil.date());
            gmTerm.setDismantler(userNo);
            int i = gmDevTermMapper.updateById(gmTerm);
            if (i > 0) {
                return R.ok().msg("拆除成功");
            } else {
                return R.failure().msg("拆除失败");
            }
        }
        return R.ok().msg("拆除成功");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public R deletePointTermMeter(SaveTermMeterRequest request) {
        String orgNo = AuthUtils.getOrgNo();
        String userNo = AuthUtils.getUserNo();
        request.setOrgNo(orgNo);
        request.setUserNo(userNo);
        String[] meterIds = request.getMeterId().split(",");
        //更新表计状态
        if (meterIds.length > 0) {
            //查询表计信息
            GmDevMeter gmDevMeter1 = gmDevMeterMapper.selectById(meterIds[0]);
            //调用数据中心接口
            logger.info("拆除终端和表计参数：" + gmDevMeter1.getMeasPointId());
            R<?> r = dataCenterCommonService.delTermMeter(gmDevMeter1.getMeasPointId());
            logger.info("拆除终端和表计返回值：" + r);
            if (r.getCode() != 200) {
                return R.failure().msg(r.getMsg());
            }
            for (String item : meterIds) {
                GmDevMeter gmDevMeter = new GmDevMeter();
                gmDevMeter.setId(Long.valueOf(item));
                gmDevMeter.setDevMeterStatus(7);
                gmDevMeter.setAccessGatewayId(0L);
                gmDevMeter.setModifier(userNo);
                gmDevMeter.setGmtModified(DateUtil.date().getTime());
                gmDevMeterMapper.updateById(gmDevMeter);
                //删除用户和表计的关系
                deleteInstPointMeterCeResource(item);
            }
        }
        //拆除表计和用能点的关系
        Map<String, Object> map = Maps.newHashMap();
        map.put("meterIds", meterIds);
        instCeResourceMapper.deleteMeterPoint(map);
        int i = logDevMeterDismantle(request);

        if (i > 0) {
            return R.ok().msg("拆除成功");
        } else {
            return R.failure().msg("拆除失败");
        }
    }

    public void delPointTermCeResource(String instPointTermId, List<String> meterIds) {
        if (CollectionUtil.isNotEmpty(meterIds)) {
            //删除用户和表计的关系
            meterIds.forEach(this::deleteInstPointMeterCeResource);
        }
        //删除用户和终端表关系
        deleteInstPointTermCeResource(instPointTermId);
    }

    /**
     * 新增表计日志表
     */
    public int logDevMeterInstall(SaveTermMeterRequest request) {
        LogDevMeterInstall logDevMeterInstall = new LogDevMeterInstall()
                .setDevTermId(Long.valueOf(request.getDevTermId()))
                .setDevMeterId(Long.valueOf(request.getMeterId()))
                .setDevMeterStartReadingInfo(request.getDevMeterStartReadingInfo())
                .setHandleStatus(1)
                .setHandleResult("")
                .setModifier(request.getUserNo())
                .setCreator(request.getUserNo())
                .setGmtModified(System.currentTimeMillis())
                .setGmtCreate(System.currentTimeMillis())
                .setVersion(1);
        return logDevMeterInstallMapper.insert(logDevMeterInstall);
    }

    /**
     * 修改表计日志表
     */
    public int logDevMeterChange(SaveTermMeterRequest request) {
        LogDevMeterChange logDevMeterChange = new LogDevMeterChange()
                .setHandleStatus(1)
                .setHandleResult("")
                .setOldDevMeterId(Long.valueOf(request.getMeterId()))
                .setOldDevMeterEndReadingInfo(request.getDevMeterStartReadingInfo())
                .setOldDevTermId(Long.valueOf(request.getDevTermId()))
                .setNewDevMeterId(Long.valueOf(request.getNewMeterId()))
                .setNewDevTermId(Long.valueOf(request.getNewMeterId()))
                .setNewDevMeterStartReadingInfo(request.getNewDevMeterStartReadingInfo())
                .setModifier(request.getUserNo())
                .setCreator(request.getUserNo())
                .setGmtModified(System.currentTimeMillis())
                .setGmtCreate(System.currentTimeMillis())
                .setVersion(1);
        return logDevMeterChangeMapper.insert(logDevMeterChange);
    }

    /**
     * 拆除表计日志表
     */
    public int logDevMeterDismantle(SaveTermMeterRequest request) {
        LogDevMeterDismantle logDevMeterDismantle = new LogDevMeterDismantle()
                .setDevMeterId(Long.valueOf(request.getMeterId()))
                .setDevMeterEndReadingInfo("{}")
                .setDevTermId(Long.valueOf(request.getDevTermId()))
                .setHandleStatus(1)
                .setHandleResult("")
                .setModifier(request.getUserNo())
                .setCreator(request.getUserNo())
                .setGmtModified(System.currentTimeMillis())
                .setGmtCreate(System.currentTimeMillis())
                .setVersion(1);
        return logDevMeterDismantleMapper.insert(logDevMeterDismantle);
    }

    /**
     * 修改表计
     */
    public void updateMeterById(SaveTermMeterRequest request) {
        //网关标识
        String termAccessGatewayId = request.getTermAccessGatewayId();
        GmDevMeter gmDevMeter = new GmDevMeter();
        gmDevMeter.setId(Long.valueOf(request.getMeterId()));
        gmDevMeter.setDevMeterCommAddr(request.getMeterAddr());
        gmDevMeter.setDevMeterName(request.getDevMeterName());
        gmDevMeter.setDevMeterType(Integer.valueOf(request.getDevMeterType()));
        gmDevMeter.setDevMeterStatus(Integer.valueOf(request.getDevMeterStatus()));
        gmDevMeter.setMeasPointId(request.getMeasPointId());
        gmDevMeter.setAccessMeasureId(request.getAccessMeasureId());
        gmDevMeter.setAccessGatewayId(StrUtil.isNotBlank(termAccessGatewayId) ? Long.valueOf(termAccessGatewayId) : null);
        gmDevMeter.setSelfRate(request.getSelfRate());
        gmDevMeter.setCtRate(request.getCtRate());
        gmDevMeter.setPtRate(request.getPtRate());
        gmDevMeter.setInstallTime(DateUtil.date());
        gmDevMeter.setInstaller(request.getUserNo());
        gmDevMeter.setGotorunner(request.getUserNo());
        gmDevMeter.setGotorunTime(DateUtil.date());
        gmDevMeterMapper.updateById(gmDevMeter);
    }

    /**
     * 删除用户和表计的关系
     */
    public void deleteInstPointMeterCeResource(String meterId) {
        QueryWrapper<InstPointMeterCeResource> queryWrapper = new QueryWrapper<InstPointMeterCeResource>()
                .eq("dev_meter_id", Long.valueOf(meterId));
        instPointMeterCeResourceMapper.delete(queryWrapper);
    }

    /**
     * 删除用户和终端的关系
     */
    public void deleteInstPointTermCeResource(String instPointTermId) {
        instPointTermCeResourceMapper.deleteById(instPointTermId);
    }

}
