package com.iesms.bizprocessors.dingiiotgateway.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author Lin yicheng
 * @date 2022/3/22 14:03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class DingiMqttmsgReceivedLog {

    /**
     * ID
     */
    private Long id;

    /**
     * 报文体
     */
    private String payload;

    /**
     * 主题
     */
    private String topic;

    /**
     * 服务质量
     */
    private int qos;

    /**
     * 是否保存
     */
    private int retained;

    /**
     * 是否复制
     */
    private int duplicate;

    /**
     * 接收消息产品
     */
    private String receivedProductKey;

    /**
     * 接收消息客户端标识
     */
    private String receivedClientId;

    /**
     * 接收消息标识
     */
    private String receivedMessageId;

    /**
     * 创建时间
     */
    private Long gmtCreate;

}
