package com.iesms.bizprocessors.dingiiotgateway.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class GmopsDevMeter implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 设备工况标识;SnowflakeId
     */
    private Long id;
    
    /**
     * 量测表计标识
     */
    private Long devMeterId;
    
    /**
     * 最近一次报文上行时间
     */
    private Long gmtMessageUp;
    
    /**
     * 最近一次量测数据上行时间
     */
    private Long gmtMeasdataUp;
    
    /**
     * 最近一次告警上行时间
     */
    private Long gmtAlarmUp;
    
    /**
     * 最近一次抄表示数上行时间
     */
    private Long gmtReadingUp;
    
    /**
     * 最近一次抄表示数值
     */
    private BigDecimal readingValue;
    
    /**
     * 最近一次量测表计状态;1 - 打开；0 - 关闭；
     */
    private Integer meterStateOpen;
    
    /**
     * 最近一次量测数据集;针对V-SVG，
{
    "gen_watt_state_svg_run": true,    // SVG运行状态 true / false : 运行 / 停机
    "gen_watt_state_svg_fault": false  // SVG系统故障 true / false : 故障 / 正常
     */
    private String measDataInfoSet;
    
    /**
     * 是否有效
     */
    private Boolean isValid;
    
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    
    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;
    
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    
    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;
    
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    
    /**
     * 失效时间;为0表示为空
     */
    private Long gmtInvalid;
    
    /**
     * 版本号;用于乐观锁
     */
    private Integer version;
    
}