package com.iesms.bizprocessors.gaeadcu.request;

import com.iesms.bizprocessors.common.request.BaseRequest;
import com.iesms.bizprocessors.gaeadcu.response.GaeadcuAircondOperateResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;
import java.util.Set;

/**
 * iesms-bizprocessors-gaeadcu-api
 * com.iesms.bizprocessors.gaeadcu.request
 *
 * @author Nick Zhang
 * @version 1.0.0
 * @since 2021-07-14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GaeadcuAircondOperateResquest implements BaseRequest<GaeadcuAircondOperateResponse> {

    private static final long serialVersionUID = 2704258158365526404L;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 采集终端通讯地址
     */
    private String devTermCommAddr;

    /**
     * 量测通信地址集合（空调内机通讯地址）
     */
    private Set<String> devMeterCommAddrSets;

    /**
     * 操作参数
     *  key: 操作参数编码，value: 操作参数值
     *      空调运行状态（开机/关机） key传：gen_aircond_state_open，value传：open开机 / close关机，上面的operateParamType值传 03 - 遥控
     *      空调设定温度 key传：gen_aircond_temp_setting，value传：设定温度值，单位：摄氏度 ℃），上面的operateParamType值传 04 - 遥调命令（浮点）
     *      空调设定模式 key传：gen_aircond_statechar_mode_setting，value传：设定模式，1个字节，16进制字符串（2位），08 - 制热；04 - 送风；02 - 除湿；01 - 制冷；），上面的operateParamType值传 06 - 遥调命令（字符串）
     *      空调设定风速 key传：gen_aircond_statechar_speed_setting，value传：设定风速，1个字节，16进制字符串（2位），04 - 低速；02 - 中速；01 - 高速；），上面的operateParamType值传 06 - 遥调命令（字符串）
     */
    private Map<String, String> operateParamMap;

    @Override
    public Class<GaeadcuAircondOperateResponse> getResponseClass() {
        return GaeadcuAircondOperateResponse.class;
    }

}
