package com.iesms.bizprocessors.gaeadcu.service;

import com.iesms.bizprocessors.gaeadcu.response.AirConditionerResponse;

import java.util.Map;

/**
 * 空调控制和设置参数
 */
public interface AirConditionerControlService {

    /**
     * 控制开关机和设置参数
     * @param meterAddress 表计地址
     * @param termAddress 终端地址
     * @param map 参数标识及其参数
     * @return
     */
    AirConditionerResponse switchOnAndOffAndSet(String meterAddress, String termAddress, Map<String, String> map);


    /**
     * 设置一段时间之内的负荷值
     * @param meterAddress 表计地址
     * @param termAddress 终端地址
     * @param map 参数标识及其参数
     * @return
     */
    AirConditionerResponse setLoadValueAccordTime(String meterAddress, String termAddress, Map<String, String> map);
}
