package com.iknowpower.bm.etsms.evcar.ccs.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.*;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ebikepay.openservices.request.InnerAccountLoadRequest;
import com.ebikepay.openservices.response.InnerAccountLoadResponse;
import com.ebikepay.openservices.service.InnerAccountService;
import com.google.common.collect.Lists;
import com.iknowpower.bm.etsms.commons.model.enums.BillingClassEnum;
import com.iknowpower.bm.etsms.commons.model.enums.BillingModelEnum;
import com.iknowpower.bm.etsms.commons.model.enums.BillingSublassEnum;
import com.iknowpower.bm.etsms.commons.model.jsonobject.BillingParamsJsonObject;
import com.iknowpower.bm.etsms.evcar.ccs.model.dto.EvcarRealTimeDataCurvePointDto;
import com.iknowpower.bm.etsms.evcar.ccs.model.entity.EbikeChargeuser;
import com.iknowpower.bm.etsms.evcar.ccs.model.entity.OrderEvCharging;
import com.iknowpower.bm.etsms.evcar.ccs.model.entity.OrderEvChargingHis;
import com.iknowpower.bm.etsms.evcar.ccs.model.enums.OrderChargeModeEnum;
import com.iknowpower.bm.etsms.evcar.ccs.model.enums.OrderChargePayTypeEnum;
import com.iknowpower.bm.etsms.evcar.ccs.model.enums.OrderChargeStatusEnum;
import com.iknowpower.bm.etsms.evcar.ccs.model.enums.OrderPayClosingModeEnum;
import com.iknowpower.bm.etsms.evcar.ccs.model.jsonobject.OrderPayAccountInfoJsonObject;
import com.iknowpower.bm.etsms.evcar.ccs.model.jsonobject.OrderSharingReceiversJsonObject;
import com.iknowpower.bm.etsms.evcar.ccs.model.request.EvcarChargeFinishRequest;
import com.iknowpower.bm.etsms.evcar.ccs.model.request.EvcarChargeOpenRequest;
import com.iknowpower.bm.etsms.evcar.ccs.model.request.EvcarRealTimeDataCurveByChargingGunNoRequest;
import com.iknowpower.bm.etsms.evcar.ccs.model.request.EvcarRealTimeDataCurveByChargingOrderNoRequest;
import com.iknowpower.bm.etsms.evcar.ccs.model.response.EvcarChargeFinishResponse;
import com.iknowpower.bm.etsms.evcar.ccs.model.response.EvcarChargeOpenResponse;
import com.iknowpower.bm.etsms.evcar.ccs.model.response.EvcarRealTimeDataCurveByChargingGunNoResponse;
import com.iknowpower.bm.etsms.evcar.ccs.model.response.EvcarRealTimeDataCurveByChargingOrderNoResponse;
import com.iknowpower.bm.etsms.evcar.ccs.service.EbikeChargeuserService;
import com.iknowpower.bm.etsms.evcar.ccs.service.EvcarCoreChargeService;
import com.iknowpower.bm.etsms.evcar.ccs.service.OrderEvChargingHisService;
import com.iknowpower.bm.etsms.evcar.ccs.service.OrderEvChargingService;
import com.iknowpower.bm.etsms.iotdev.ams.dao.mapper.DevAssetEvChargingPilesMapper;
import com.iknowpower.bm.etsms.iotdev.ams.dao.mapper.DevEvChargingGunMapper;
import com.iknowpower.bm.etsms.iotdev.ams.dao.mapper.DevEvChargingPileMapper;
import com.iknowpower.bm.etsms.iotdev.ams.model.entity.DevAssetEvChargingPiles;
import com.iknowpower.bm.etsms.iotdev.ams.model.entity.DevEvChargingGun;
import com.iknowpower.bm.etsms.iotdev.is.dao.mapper.RunDevEvChargingGunMapper;
import com.iknowpower.bm.etsms.iotdev.is.dao.mapper.RunDevEvChargingPileMapper;
import com.iknowpower.bm.etsms.iotdev.is.model.entity.RunDevEvChargingGun;
import com.iknowpower.bm.etsms.oper.bms.dao.mapper.OperEvChargingStationBillingInfoMapper;
import com.iknowpower.bm.etsms.oper.bms.model.entity.OperEvChargingStationBillingInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

/**
 * bm-etsms-evcar-ccs-service-impl
 * com.iknowpower.bm.etsms.evcar.ccs.service.impl
 *
 * @author Nick Zhang
 * @version 1.0.0
 * @since 2021-05-08
 */
@Service(value = "bmEtsmsEvcarCoreChargeService")
public class EvcarCoreChargeServiceImpl implements EvcarCoreChargeService {

    private static final Logger LOGGER = LoggerFactory.getLogger(EvcarCoreChargeServiceImpl.class);

    @Resource
    private InnerAccountService innerAccountService;

    @Resource(name = "bmEtsmsOrderEvChargingService")
    private OrderEvChargingService orderEvChargingService;

    @Resource(name = "bmEtsmsOrderEvChargingHisService")
    private OrderEvChargingHisService orderEvChargingHisService;

    @Resource(name = "bmEtsmsEbikeChargeuserService")
    private EbikeChargeuserService ebikeChargeuserService;

    @Resource
    private OperEvChargingStationBillingInfoMapper operEvChargingStationBillingInfoMapper;

    @Resource
    private DevAssetEvChargingPilesMapper devAssetEvChargingPilesMapper;

    @Resource
    private DevEvChargingPileMapper devEvChargingPileMapper;

    @Resource
    private RunDevEvChargingPileMapper runDevEvChargingPileMapper;

    @Resource
    private DevEvChargingGunMapper devEvChargingGunMapper;

    @Resource
    private RunDevEvChargingGunMapper runDevEvChargingGunMapper;

    @Override
    public EvcarChargeOpenResponse openCharge(EvcarChargeOpenRequest openRequest) {
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("start openCharge");
            LOGGER.debug("EvcarChargeOpenRequest    : " + JSONUtil.toJsonStr(openRequest));
        }

        EvcarChargeOpenResponse openResponse = new EvcarChargeOpenResponse();
        openResponse.setCode(400000);
        openResponse.setMsg("开启充电失败");
        if(openRequest != null && StrUtil.isNotBlank(openRequest.getOrgNo()) && StrUtil.isNotBlank(openRequest.getChargingGunNo())) {
            String chargeUserNo = openRequest.getChargeUserNo();
            String chargeUserType = openRequest.getChargeUserType();
            Integer chargeMode = openRequest.getChargeMode();
            EbikeChargeuser ebikeChargeuser = null;
            if(StrUtil.equalsAny(chargeUserType, "10", "30")) {
                ebikeChargeuser = ebikeChargeuserService.getOne(Wrappers.<EbikeChargeuser>lambdaQuery().eq(EbikeChargeuser::getChargeUserNo, chargeUserNo).in(EbikeChargeuser::getChargeUserType, "10", "30"), false);
            }
            else {
                ebikeChargeuser = ebikeChargeuserService.getOne(Wrappers.<EbikeChargeuser>lambdaQuery().eq(EbikeChargeuser::getChargeUserNo, chargeUserNo).eq(EbikeChargeuser::getChargeUserType, chargeUserType), false);
            }
            if(ebikeChargeuser != null) {
                InnerAccountLoadRequest innerAccountLoadRequest = new InnerAccountLoadRequest();
                innerAccountLoadRequest.setUserType("bike_user");
                innerAccountLoadRequest.setUserId(chargeUserNo);
                InnerAccountLoadResponse innerAccountLoadResponse = innerAccountService.loadInnerAccount(innerAccountLoadRequest);
                int initBalance = 0;
                if(innerAccountLoadResponse != null && innerAccountLoadResponse.isSuccess()) {
                    initBalance = BigDecimal.valueOf(innerAccountLoadResponse.getInnerAccount().getAccountBalance()).multiply(BigDecimal.valueOf(100.0D)).intValue();
                }
                if(initBalance > 0) {
                    DevEvChargingGun devEvChargingGun = devEvChargingGunMapper.selectOne(Wrappers.<DevEvChargingGun>lambdaQuery().eq(DevEvChargingGun::getOrgNo, openRequest.getOrgNo()).eq(DevEvChargingGun::getChargingGunNo, openRequest.getChargingGunNo()));
                    if(devEvChargingGun != null && StrUtil.length(devEvChargingGun.getChargingGunNo()) > 2) {
                        String chargingOrderNo = StrUtil.padPre(String.valueOf(IdUtil.getSnowflake(1L, 1L).nextId()), 32, "0");
                        String chargingGunNo = devEvChargingGun.getChargingGunNo();
                        String pileNo = StrUtil.sub(chargingGunNo, 0, chargingGunNo.length() - 2);
                        Integer gunSn = devEvChargingGun.getChargingGunSn();
                        if(LOGGER.isDebugEnabled()) {
                            LOGGER.debug("chargingOrderNo   : " + chargingOrderNo);
                            LOGGER.debug("chargingGunNo     : " + chargingGunNo);
                            LOGGER.debug("pileNo            : " + pileNo);
                            LOGGER.debug("gunSn             : " + gunSn);
                        }

                        List<OperEvChargingStationBillingInfo> operEvChargingStationBillingInfoList = operEvChargingStationBillingInfoMapper.selectList(Wrappers.<OperEvChargingStationBillingInfo>lambdaQuery().eq(OperEvChargingStationBillingInfo::getChargingStationId, devEvChargingGun.getChargingStationId()));
                        OperEvChargingStationBillingInfo operEvChargingStationBillingInfo = null;
                        if(operEvChargingStationBillingInfoList != null && operEvChargingStationBillingInfoList.size() > 0) {
                            operEvChargingStationBillingInfo = operEvChargingStationBillingInfoList.get(0);
                        }

                        if(operEvChargingStationBillingInfo == null) {
                            LOGGER.error("开启充电失败（计费方案为空）");
                            openResponse.setCode(400000);
                            openResponse.setMsg("开启充电失败");
                        }
                        else {
                            OrderEvCharging orderEvCharging = OrderEvCharging.builder()
                                .primaryOrgNo(openRequest.getOrgNo())
                                .orgNo(openRequest.getOrgNo())
                                .chargingOrderNo(chargingOrderNo)
                                .chargingGunId(devEvChargingGun.getId())
                                .chargingPileId(devEvChargingGun.getChargingPileId())
                                .chargingStationId(devEvChargingGun.getChargingStationId())
                                .chargeUserId(ebikeChargeuser.getChargeUserId())
                                .cardId("")
                                .evcarVinCode("")
                                .customerId(0L)
                                .chargeTime(DateUtil.date())
                                .chargeStatus(OrderChargeStatusEnum.WAITING_FOR_CHARGING_OPEN)
                                .chargeMode(OrderChargeModeEnum.SCAN_ORCODE)
                                .chargePayType(OrderChargePayTypeEnum.PAY_BY_INNERACCT)
                                .enterUserType("ebike_transit")
                                .enterUserId("10000000")
                                .sharingReceivers(OrderSharingReceiversJsonObject.builder().build())
                                .sharingMoneyFreezeCycle(0)
                                .payAccountInfo(OrderPayAccountInfoJsonObject.builder().build())
                                .payClosingMode(OrderPayClosingModeEnum.AFTERPAY_AFTERSETTLE)
                                .prepayMoney(BigDecimal.ZERO)
                                .laterpayMoney(BigDecimal.ZERO)
                                .billingTmplId(operEvChargingStationBillingInfo.getBillingTmplId())
                                .build();

                            if(operEvChargingStationBillingInfo.getBillingTmplId() == 175436733530243085L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(4).ratePeriodType(1).priceRate01("0").priceRate02("0.9078").priceRate03("0.5996").priceRate04("0.3599").priceService("0.7").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 193403013851774980L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("single").priceTotal("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 193939265380417552L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3629").priceRate02("0.6048").priceRate03("0.9158").priceRate04("0.6048").priceRate05("0.9158").priceRate06("0.6048").priceRate07("0.3629").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 193759941499027471L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3629").priceRate02("0.6048").priceRate03("0.9158").priceRate04("0.6048").priceRate05("0.9158").priceRate06("0.6048").priceRate07("0.3629").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 193922854641729541L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3629").priceRate02("0.6048").priceRate03("0.9158").priceRate04("0.6048").priceRate05("0.9158").priceRate06("0.6048").priceRate07("0.3629").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.3").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 200691030658383887L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("single").priceTotal("1.0").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 206091882353131530L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.4072").priceRate02("0.6750").priceRate03("1.0192").priceRate04("0.6750").priceRate05("0.6750").priceRate06("1.0192").priceRate07("0.6750").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.3").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 206091930539393034L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.4247").priceRate02("0.7052").priceRate03("1.0658").priceRate04("0.7052").priceRate05("1.0658").priceRate06("0.7052").priceRate07("0.4247").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 206092090526924818L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.4247").priceRate02("0.7052").priceRate03("1.0658").priceRate04("0.7052").priceRate05("1.0658").priceRate06("0.7052").priceRate07("0.4247").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.3").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 206092331682627593L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.4072").priceRate02("0.6750").priceRate03("1.0192").priceRate04("0.6750").priceRate05("1.0192").priceRate06("0.6750").priceRate07("0.4072").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 209316715901747214L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.2995").priceRate02("0.6744").priceRate03("1.1270").priceRate04("0.6744").priceRate05("1.1270").priceRate06("0.6744").priceRate07("0.2995").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.3").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 209317335314464781L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.2995").priceRate02("0.6744").priceRate03("1.1270").priceRate04("0.6744").priceRate05("1.1270").priceRate06("0.6744").priceRate07("0.2995").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 209317526104965124L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3119").priceRate02("0.7046").priceRate03("1.1787").priceRate04("0.7046").priceRate05("1.1787").priceRate06("0.7046").priceRate07("0.3119").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.3").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 209317694952964108L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3119").priceRate02("0.7046").priceRate03("1.1787").priceRate04("0.7046").priceRate05("1.1787").priceRate06("0.7046").priceRate07("0.3119").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 214378021681889296L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3154").priceRate02("0.7081").priceRate03("1.1822").priceRate04("0.7081").priceRate05("1.1822").priceRate06("0.7081").priceRate07("0.3154").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 214378356032929798L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3030").priceRate02("0.6779").priceRate03("1.1305").priceRate04("0.6779").priceRate05("1.1305").priceRate06("0.6779").priceRate07("0.3030").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.5").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 214379776392036360L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3154").priceRate02("0.7081").priceRate03("1.1822").priceRate04("0.7081").priceRate05("1.1822").priceRate06("0.7081").priceRate07("0.3154").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.3").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            else if(operEvChargingStationBillingInfo.getBillingTmplId() == 214380230983286797L) {
                                orderEvCharging.setBillingClass(BillingClassEnum.EVCAR_BILLING_TMPL);
                                orderEvCharging.setBillingSubclass(BillingSublassEnum.ECONS);
                                orderEvCharging.setBillingParams(BillingParamsJsonObject.builder().priceRateType("multi").rateCount(7).ratePeriodType(2).priceRate01("0.3030").priceRate02("0.6779").priceRate03("1.1305").priceRate04("0.6779").priceRate05("1.1305").priceRate06("0.6779").priceRate07("0.3030").numberRatePeriod01(1).numberRatePeriod02(2).numberRatePeriod03(3).numberRatePeriod04(4).numberRatePeriod05(5).numberRatePeriod06(6).numberRatePeriod07(7).startValueRatePeriod01("00:00").startValueRatePeriod02("08:00").startValueRatePeriod03("09:00").startValueRatePeriod04("12:00").startValueRatePeriod05("17:00").startValueRatePeriod06("22:00").startValueRatePeriod01("23:00").priceService("0.3").build());
                                orderEvCharging.setBillingModel(BillingModelEnum.LOCAL);
                                orderEvCharging.setBillingInterval(15);
                            }
                            orderEvChargingService.save(orderEvCharging);

                            //
                            RunDevEvChargingGun runDevEvChargingGun = runDevEvChargingGunMapper.selectOne(Wrappers.<RunDevEvChargingGun>lambdaQuery().eq(RunDevEvChargingGun::getChargingGunId, devEvChargingGun.getId()));
                            if(runDevEvChargingGun != null) {
                                runDevEvChargingGun.setRunStatus(1);
                                runDevEvChargingGun.setRunStatusTime(DateUtil.date());
                                runDevEvChargingGunMapper.updateById(runDevEvChargingGun);
                                LOGGER.info("update runDevEvChargingGun : " + runDevEvChargingGun);
                            }

                            DevAssetEvChargingPiles devAssetEvChargingPiles = devAssetEvChargingPilesMapper.selectOne(Wrappers.<DevAssetEvChargingPiles>lambdaQuery().eq(DevAssetEvChargingPiles::getChargingPileNo, pileNo));
                            if(devAssetEvChargingPiles != null && StrUtil.equals(devAssetEvChargingPiles.getChargingPileCommProto(), "EVCAR_SZWINLINE")) {
                                com.iknowpower.gateway.evcar.szwinline.frame.request.ServeStartChargingRequest serveStartChargingRequest = new com.iknowpower.gateway.evcar.szwinline.frame.request.ServeStartChargingRequest(
                                    new com.iknowpower.gateway.evcar.szwinline.pack.data.Bcd16(chargingOrderNo),
                                    new com.iknowpower.gateway.evcar.szwinline.pack.data.Bcd7(pileNo),
                                    new com.iknowpower.gateway.evcar.szwinline.pack.data.Bcd1(gunSn.toString()),
                                    new com.iknowpower.gateway.evcar.szwinline.pack.data.Bcd8("0000000000000000"),
                                    new byte[8], initBalance);
                                // PricingModelSetRequest readMonitoringData = new PricingModelSetRequest(new Bcd7("7"),1,2,3,4,5,0);
                                // 需要注意的是发送消息是用device的 send 方法 而不是context的
                                try {
                                    com.iknowpower.gateway.evcar.szwinline.context.ZServiceContext.getDeviceRegistry().getDevice(pileNo).send(serveStartChargingRequest);
                                    LOGGER.info(">>> 发送运营平台远程控制启机，serveStartChargingRequest   : {}", serveStartChargingRequest);
                                }
                                catch(Exception e) {
                                    LOGGER.error(e.getMessage(), e.fillInStackTrace());
                                }
                            }
                            else if(devAssetEvChargingPiles != null && StrUtil.equals(devAssetEvChargingPiles.getChargingPileCommProto(), "EVCAR_AHYIDIAN")) {
                                com.iknowpower.gateway.evcar.ahyidian.frame.request.ServeStartChargingRequest serveStartChargingRequest = new com.iknowpower.gateway.evcar.ahyidian.frame.request.ServeStartChargingRequest(
                                    new com.iknowpower.gateway.evcar.ahyidian.pack.data.Bcd16(chargingOrderNo),
                                    new com.iknowpower.gateway.evcar.ahyidian.pack.data.Bcd7(pileNo),
                                    new com.iknowpower.gateway.evcar.ahyidian.pack.data.Bcd1(gunSn.toString()),
                                    new com.iknowpower.gateway.evcar.ahyidian.pack.data.Bcd8("0000000000000000"),
                                    new byte[8], initBalance);
                                // PricingModelSetRequest readMonitoringData = new PricingModelSetRequest(new Bcd7("7"),1,2,3,4,5,0);
                                // 需要注意的是发送消息是用device的 send 方法 而不是context的
                                try {
                                    com.iknowpower.gateway.evcar.ahyidian.context.ZServiceContext.getDeviceRegistry().getDevice(pileNo).send(serveStartChargingRequest);
                                    LOGGER.info(">>> 发送运营平台远程控制启机，serveStartChargingRequest   : {}", serveStartChargingRequest);
                                }
                                catch(Exception e) {
                                    LOGGER.error(e.getMessage(), e.fillInStackTrace());
                                }
                            }

                            openResponse.setCode(200);
                            openResponse.setMsg("开启充电成功");
                        }
                    }
                }
            }
            else {
                openResponse.setCode(400001);
                openResponse.setMsg("充电用户不存在");
            }
        }

        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("EvcarChargeOpenResponse   : " + JSONUtil.toJsonStr(openResponse));
            LOGGER.debug("end openCharge");
        }
        return openResponse;
    }

    @Override
    public EvcarChargeFinishResponse finshCharge(EvcarChargeFinishRequest finishRequest) {
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("start finshCharge");
            LOGGER.debug("EvcarChargeFinishRequest  : " + JSONUtil.toJsonStr(finishRequest));
        }

        EvcarChargeFinishResponse finishResponse = new EvcarChargeFinishResponse();
        finishResponse.setCode(400000);
        finishResponse.setMsg("结束充电失败");
        LOGGER.info("EvcarChargeFinishRequest  : " + JSONUtil.toJsonStr(finishRequest));
        if(finishRequest != null && StrUtil.isNotBlank(finishRequest.getOrgNo()) && StrUtil.isNotBlank(finishRequest.getChargingGunNo())) {
            DevEvChargingGun devEvChargingGun = devEvChargingGunMapper.selectOne(Wrappers.<DevEvChargingGun>lambdaQuery().eq(DevEvChargingGun::getOrgNo, finishRequest.getOrgNo()).eq(DevEvChargingGun::getChargingGunNo, finishRequest.getChargingGunNo()));
            if(devEvChargingGun != null && StrUtil.length(devEvChargingGun.getChargingGunNo()) > 2) {
                String chargingOrderNo = StrUtil.padPre(String.valueOf(IdUtil.getSnowflake(1L, 1L).nextId()), 32, "0");
                String chargingGunNo = devEvChargingGun.getChargingGunNo();
                String pileNo = StrUtil.sub(chargingGunNo, 0, chargingGunNo.length() - 2);
                Integer gunSn = devEvChargingGun.getChargingGunSn();
                if(LOGGER.isDebugEnabled()) {
                    LOGGER.debug("chargingOrderNo   : " + chargingOrderNo);
                    LOGGER.debug("chargingGunNo     : " + chargingGunNo);
                    LOGGER.debug("pileNo            : " + pileNo);
                    LOGGER.debug("gunSn             : " + gunSn);
                }
                LOGGER.info("pileNo  : " + pileNo);
                LOGGER.info("gunSn  : " + gunSn);
                DevAssetEvChargingPiles devAssetEvChargingPiles = devAssetEvChargingPilesMapper.selectOne(Wrappers.<DevAssetEvChargingPiles>lambdaQuery().eq(DevAssetEvChargingPiles::getChargingPileNo, pileNo));
                if(devAssetEvChargingPiles != null && StrUtil.equals(devAssetEvChargingPiles.getChargingPileCommProto(), "EVCAR_SZWINLINE")) {
                    com.iknowpower.gateway.evcar.szwinline.frame.request.ServeRemoteShutdownRequest serveRemoteShutdownRequest = new com.iknowpower.gateway.evcar.szwinline.frame.request.ServeRemoteShutdownRequest(
                        new com.iknowpower.gateway.evcar.szwinline.pack.data.Bcd7(pileNo), new com.iknowpower.gateway.evcar.szwinline.pack.data.Bcd1(gunSn.toString()));
                    // PricingModelSetRequest readMonitoringData = new PricingModelSetRequest(new Bcd7("7"),1,2,3,4,5,0);
                    // 需要注意的是发送消息是用device的 send 方法 而不是context的
                    try {
                        LOGGER.debug("serveRemoteShutdownRequest  : " + JSONUtil.toJsonStr(serveRemoteShutdownRequest));
                        com.iknowpower.gateway.evcar.szwinline.context.ZServiceContext.getDeviceRegistry().getDevice(pileNo).send(serveRemoteShutdownRequest);
                        LOGGER.info(">>> 发送运营平台远程控制停机，serveRemoteShutdownRequest  : {}", serveRemoteShutdownRequest);
                    }
                    catch(Exception e) {
                        e.printStackTrace();
                    }
                }
                else if(devAssetEvChargingPiles != null && StrUtil.equals(devAssetEvChargingPiles.getChargingPileCommProto(), "EVCAR_AHYIDIAN")) {
                    com.iknowpower.gateway.evcar.ahyidian.frame.request.ServeRemoteShutdownRequest serveRemoteShutdownRequest = new com.iknowpower.gateway.evcar.ahyidian.frame.request.ServeRemoteShutdownRequest(
                        new com.iknowpower.gateway.evcar.ahyidian.pack.data.Bcd7(pileNo), new com.iknowpower.gateway.evcar.ahyidian.pack.data.Bcd1(gunSn.toString()));
                    // PricingModelSetRequest readMonitoringData = new PricingModelSetRequest(new Bcd7("7"),1,2,3,4,5,0);
                    // 需要注意的是发送消息是用device的 send 方法 而不是context的
                    try {
                        com.iknowpower.gateway.evcar.ahyidian.context.ZServiceContext.getDeviceRegistry().getDevice(pileNo).send(serveRemoteShutdownRequest);
                        LOGGER.info(">>> 发送运营平台远程控制停机，serveRemoteShutdownRequest  : {}", serveRemoteShutdownRequest);
                    }
                    catch(Exception e) {
                        e.printStackTrace();
                    }
                }

                finishResponse.setCode(200);
                finishResponse.setMsg("结束充电成功");
            }
        }

        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("EvcarChargeFinishResponse   : " + JSONUtil.toJsonStr(finishResponse));
            LOGGER.debug("end finshCharge");
        }
        return finishResponse;
    }

    @Override
    public EvcarRealTimeDataCurveByChargingGunNoResponse getEvcarRealTimeDataCurveByChargingGunNo(EvcarRealTimeDataCurveByChargingGunNoRequest getRequest) {
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("start getRequest");
            LOGGER.debug("EvcarRealTimeDataCurveByChargingGunNoRequest  : " + JSONUtil.toJsonStr(getRequest));
        }

        EvcarRealTimeDataCurveByChargingGunNoResponse getResponse = new EvcarRealTimeDataCurveByChargingGunNoResponse();
        getResponse.setCode(400000);
        getResponse.setMsg("获取实时数据曲线失败");

        if(getRequest != null && StrUtil.isNotBlank(getRequest.getChargingGunNo())) {
            getResponse.setCode(200);
            getResponse.setMsg("获取实时数据曲线成功");
            getResponse.setChargingGunNo(getRequest.getChargingGunNo());
            Date startTime = getRequest.getStartTime();
            Date endTime = getRequest.getEndTime();
            List<EvcarRealTimeDataCurvePointDto> evcarRealTimeDataCurvePointList = Lists.newArrayList();
            if(startTime != null && endTime != null && startTime.before(endTime)) {
                Date timeLabel = startTime;
                while(timeLabel.before(endTime)) {
                    EvcarRealTimeDataCurvePointDto evcarRealTimeDataCurvePoint = EvcarRealTimeDataCurvePointDto.builder()
                        .timeLabel(timeLabel)
                        .outputVoltage(RandomUtil.randomBigDecimal(new BigDecimal("220.0"), new BigDecimal("260.0")).setScale(4, BigDecimal.ROUND_HALF_UP))
                        .outputCurrent(RandomUtil.randomBigDecimal(new BigDecimal("10.0"), new BigDecimal("200.0")).setScale(4, BigDecimal.ROUND_HALF_UP))
                        .outputPower(RandomUtil.randomBigDecimal(new BigDecimal("2.2"), new BigDecimal("52.0")).setScale(4, BigDecimal.ROUND_HALF_UP))
                        .gunLineTemperature(RandomUtil.randomBigDecimal(new BigDecimal("30.0"), new BigDecimal("90.0")).setScale(4, BigDecimal.ROUND_HALF_UP))
                        .bmsDemandVoltage(RandomUtil.randomBigDecimal(new BigDecimal("110.0"), new BigDecimal("330.0")).setScale(4, BigDecimal.ROUND_HALF_UP))
                        .bmsDemandCurrent(RandomUtil.randomBigDecimal(new BigDecimal("12.0"), new BigDecimal("240.0")).setScale(4, BigDecimal.ROUND_HALF_UP))
                        .soc(RandomUtil.randomBigDecimal(new BigDecimal("30.0"), new BigDecimal("100.0")).setScale(4, BigDecimal.ROUND_HALF_UP))
                        .build();
                    evcarRealTimeDataCurvePointList.add(evcarRealTimeDataCurvePoint);
                    timeLabel = DateUtil.offsetSecond(timeLabel, 20);
                }
            }
            getResponse.setEvcarRealTimeDataCurvePointList(evcarRealTimeDataCurvePointList);
        }

        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("EvcarChargeFinishResponse   : " + JSONUtil.toJsonStr(getResponse));
            LOGGER.debug("end getRequest");
        }
        return getResponse;
    }

    @Override
    public EvcarRealTimeDataCurveByChargingOrderNoResponse getEvcarRealTimeDataCurveByChargingOrderNo(EvcarRealTimeDataCurveByChargingOrderNoRequest getRequest) {
        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("start getRequest");
            LOGGER.debug("EvcarRealTimeDataCurveByChargingOrderNoRequest  : " + JSONUtil.toJsonStr(getRequest));
        }

        EvcarRealTimeDataCurveByChargingOrderNoResponse getResponse = new EvcarRealTimeDataCurveByChargingOrderNoResponse();
        getResponse.setCode(400000);
        getResponse.setMsg("获取实时数据曲线失败");

        if(getRequest != null && StrUtil.isNotBlank(getRequest.getChargingOrderNo())) {
            getResponse.setCode(200);
            getResponse.setMsg("获取实时数据曲线成功");
            getResponse.setChargingOrderNo(getRequest.getChargingOrderNo());
            OrderEvChargingHis orderEvChargingHis = orderEvChargingHisService.getOne(Wrappers.<OrderEvChargingHis>lambdaQuery().eq(OrderEvChargingHis::getChargingOrderNo, getRequest.getChargingOrderNo()));
            Date chargeOpenSuccessTime = orderEvChargingHis.getChargeOpenSuccessTime();
            Date chargeFinishTime = orderEvChargingHis.getChargeFinishTime();
            Date startTime = chargeOpenSuccessTime;
            Date endTime = chargeFinishTime;
            List<EvcarRealTimeDataCurvePointDto> evcarRealTimeDataCurvePointList = Lists.newArrayList();
            if(startTime.before(endTime)) {
                BigDecimal chargeStartEvcarSoc = orderEvChargingHis.getChargeStartEvcarSoc();
                Date timeLabel = startTime;
                BigDecimal soc = BigDecimal.valueOf(chargeStartEvcarSoc.doubleValue());
                while(timeLabel.before(endTime)) {
                    EvcarRealTimeDataCurvePointDto evcarRealTimeDataCurvePoint = EvcarRealTimeDataCurvePointDto.builder()
                        .timeLabel(timeLabel)
                        .outputVoltage(RandomUtil.randomBigDecimal(new BigDecimal("220.0"), new BigDecimal("260.0")).setScale(4, RoundingMode.HALF_UP))
                        .outputCurrent(RandomUtil.randomBigDecimal(new BigDecimal("10.0"), new BigDecimal("200.0")).setScale(4, RoundingMode.HALF_UP))
                        .outputPower(RandomUtil.randomBigDecimal(new BigDecimal("2.2"), new BigDecimal("52.0")).setScale(4, RoundingMode.HALF_UP))
                        .gunLineTemperature(RandomUtil.randomBigDecimal(new BigDecimal("30.0"), new BigDecimal("90.0")).setScale(4, RoundingMode.HALF_UP))
                        .bmsDemandVoltage(RandomUtil.randomBigDecimal(new BigDecimal("110.0"), new BigDecimal("330.0")).setScale(4, RoundingMode.HALF_UP))
                        .bmsDemandCurrent(RandomUtil.randomBigDecimal(new BigDecimal("12.0"), new BigDecimal("240.0")).setScale(4, RoundingMode.HALF_UP))
                        .soc(soc.compareTo(new BigDecimal("100.0")) > 0 ? new BigDecimal("100.0") : soc.setScale(4, RoundingMode.HALF_UP))
                        .build();
                    evcarRealTimeDataCurvePointList.add(evcarRealTimeDataCurvePoint);
                    timeLabel = DateUtil.offsetSecond(timeLabel, 60);
                    soc = NumberUtil.add(soc, new BigDecimal("1.0"));
                }
            }
            getResponse.setEvcarRealTimeDataCurvePointList(evcarRealTimeDataCurvePointList);
        }

        if(LOGGER.isDebugEnabled()) {
            LOGGER.debug("EvcarChargeFinishResponse   : " + JSONUtil.toJsonStr(getResponse));
            LOGGER.debug("end getRequest");
        }
        return getResponse;
    }

}
