package com.iknowpower.bm.iesms.commons.service;

import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetRangeBaseResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetRangeResponse;

import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/7/14
 */
public interface CommonMeasDataService {

    /**
     * 获取量测点最新数据
     *
     * @param request MeasDataLatestGetRequest
     * @return Map<String, MeasDataLatestInfo>
     */
    Map<String, MeasDataLatestInfo> getMeasDataLatest(MeasDataLatestGetRequest request);

    /**
     * 获取累计量曲线数据（时间范围）
     *
     * @param request MeasDataCumFreezeCurveGetRangeRequest
     * @return Map<String, List<MeasDataCumFreezeCurveValue>>
     */
    Map<String, List<MeasDataCumFreezeCurveValue>> getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest request);

    /**
     * 获取累计量曲线数据（时间点）
     *
     * @param request MeasDataCumFreezeCurveGetRequest
     * @return Map<String, MeasDataCumFreezeCurveValue>
     */
    Map<String, MeasDataCumFreezeCurveValue> getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest request);

    /**
     * 获取瞬时量曲线数据（时间点）
     *
     * @param request MeasDataInsFreezeCurveGetRequest
     * @return Map<String, MeasDataInsFreezeCurveValue>
     */
    Map<String, MeasDataInsFreezeCurveValue> getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest request);

    /**
     * 获取瞬时量曲线数据（时间范围）
     *
     * @param request MeasDataInsFreezeCurveGetRangeRequest
     * @return Map<String, List<MeasDataInsFreezeCurveValue>>
     */
    Map<String, List<MeasDataInsFreezeCurveValue>> getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest request);

    /**
     * 批量获取瞬时量曲线数据（时间范围）
     *
     * @param requests List<MeasDataInsFreezeCurveGetRangeRequest>
     * @return List<MeasDataInsFreezeCurveGetRangeBaseResponse>
     */
    List<MeasDataInsFreezeCurveGetRangeBaseResponse> getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> requests);
}
