package com.iknowpower.bm.iesms.commons.service;

import com.easesource.iot.datacenter.openservice.entity.MeasStatCumDayValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatInsDayValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatInsMonthValue;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumDayGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsDayGetRequest;

import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/7/29
 */
public interface CommonMeasStatExtendService {

    /**
     * 获取累计量日统计数据（单个日期）
     *
     * @param measPointId Long
     * @param date String
     * @param sets Set<String>
     * @return Map<String, MeasStatCumDayValue>
     */
    Map<String, MeasStatCumDayValue>  getMeasStatCumDay(Long measPointId, String date, String... sets);

    /**
     * 获取瞬时量月统计数据（单个月份）
     *
     * @param measPointId Long
     * @param month String（yyyyMM）
     * @param sets Set<String>
     * @return Map<String, MeasStatInsMonthValue>
     */
    Map<String, MeasStatInsMonthValue> getMeasStatInsMonth(Long measPointId, String month, String... sets);

    /**
     * 获取瞬时量日统计数据（单个日期）
     *
     * @param measPointId Long
     * @param date String
     * @param sets Set<String>
     * @return Map<String, MeasStatInsDayValue>
     */
    Map<String, MeasStatInsDayValue> getMeasStatInsDay(Long measPointId, String date, String... sets);
}
