package com.iknowpower.bm.iesms.commons.service;

import com.easesource.iot.datacenter.openservice.entity.MeasStatCumDayValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatInsDayValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatInsMonthValue;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumDayGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsDayGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsMonthGetRequest;

import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/7/29
 */
public interface CommonMeasStatService {

    /**
     * 获取累计量日统计数据（单个日期）
     *
     * @param request MeasStatCumDayGetRequest
     * @return Map<String, MeasStatCumDayValue>
     */
    Map<String, MeasStatCumDayValue>  getMeasStatCumDay(MeasStatCumDayGetRequest request);

    /**
     * 获取瞬时量月统计数据（单个月份）
     *
     * @param request MeasStatInsMonthGetRequest
     * @return Map<String, MeasStatInsMonthValue>
     */
    Map<String, MeasStatInsMonthValue> getMeasStatInsMonth(MeasStatInsMonthGetRequest request);

    /**
     * 获取瞬时量日统计数据（单个日期）
     *
     * @param request MeasStatInsDayGetRequest
     * @return Map<String, MeasStatInsDayValue>
     */
    Map<String, MeasStatInsDayValue> getMeasStatInsDay(MeasStatInsDayGetRequest request);
}
