package com.iknowpower.bm.iesms.commons.service;

import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/7/15
 */
public interface CommonMeasDataExtendService {

    /**
     * 获取瞬时量曲线数据（时间范围）
     *
     * @param measPointId Long
     * @param start long
     * @param end long
     * @param sets Set<String>
     * @return Map<String, List<MeasDataInsFreezeCurveValue>>
     */
    Map<String, List<MeasDataInsFreezeCurveValue>> getRangeMeasDataInsFreezeCurve(Long measPointId, long start, long end, String... sets);

    /**
     * 多个量测点的瞬时量曲线数据之和（时间范围）
     *
     * @param measPointIdList List<Long>
     * @param start long
     * @param end long
     * @param sets Set<String>
     * @return Map<String, List<MeasDataInsFreezeCurveValue>>
     */
    Map<String, List<MeasDataInsFreezeCurveValue>> getRangeMeasDataInsFreezeCurve(List<Long> measPointIdList, long start, long end, String... sets);

    /**
     * 获取累计量曲线数据（时间范围）
     *
     * @param measPointId Long
     * @param start long
     * @param end long
     * @param sets Set<String>
     * @return Map<String, List<MeasDataCumFreezeCurveValue>>
     */
    Map<String, List<MeasDataCumFreezeCurveValue>> getRangeMeasDataCumFreezeCurve(Long measPointId, long start, long end, String... sets);

    /**
     * 获取瞬时量曲线数据（时间点）
     *
     * @param measPointId Long
     * @param date long
     * @param sets Set<String>
     * @return Map<String, MeasDataInsFreezeCurveValue>
     */
    Map<String, MeasDataInsFreezeCurveValue> getMeasDataInsFreezeCurve(Long measPointId, long date, String... sets);

    /**
     * 转换数据曲线
     *
     * @param list List<MeasDataInsFreezeCurveValue>
     * @param timeInterval int
     * @return List<BigDecimal>
     */
    List<BigDecimal> convertCurveDataList(List<MeasDataInsFreezeCurveValue> list, int timeInterval);
}
